<?php

//phpinfo(); die();
$watermark = "watermark.png";
$image = $_SERVER["PATH_TRANSLATED"];

if (empty($image)) die();

if (!file_exists($image)) {
   header("404 Not Found");
   echo "File Not Found."; die();
}

$outputType = getFileType($image);

watermark($image, $watermark, $outputType);

/**
   Outputs the image $source with $watermark in the lower right corner.
   @param $source the source image
   @param $watermark the watermark to apply
   @param $outputType the type to output as (png, jpg, gif, etc.)
                      defaults to the image type of $source if left blank
*/
function watermark($source, $watermark, $outputType="") {
   $sourceType = getFileType($source);
   $watermarkType = getFileType($watermark);

   if (empty($outputType)) $outputType = $sourceType;
   //if ($outputType == "gif") $outputType = "png"; // Okay to remove after July 2004
   header("Content-type:image/$outputType");

   // Derive function names
   $createSource = "ImageCreateFrom".strtoupper($sourceType);
   $showImage = "Image".strtoupper($outputType);
   $createWatermark = "ImageCreateFrom".strtoupper($watermarkType);

   // Load original and watermark to memory
   $output = $createSource($source);
   $logo = $createWatermark($watermark);
   ImageAlphaBlending($output, true);

   // Find proper coordinates so watermark will be in the lower right corner
   $x = ImageSX($output) - ImageSX($logo);
   $y = ImageSY($output) - ImageSY($logo);

   // Display
   ImageCopy($output, $logo, $x, $y, 0, 0, ImageSX($logo), ImageSY($logo));
   $showImage($output);

   // Purge
   ImageDestroy($output);
   ImageDestroy($logo);
}

function getFileType($string) {
   $type = strtolower(eregi_replace("^(.*)\.","",$string));
   if ($type == "jpg") $type = "jpeg";
   return $type;
}

?>