/* 
  Document   : a simply layout for demoing Tab interface for static content using JavaScript Prototype
  Created on : Sept 22, 2008, 9:38:33 AM
  Modified on: Nov 28, 2008
  Author     : Ian Irving http://www.FalsePositives.com
  blog post  : http://www.falsepositives.com/index.php/2008/10/09/tab-interface-for-static-content-using-javascript-prototype/
  license    : This work is licensed under a Creative Commons License. to Share and remix with Attribution
               http://creativecommons.org/licenses/by/2.0/ca/

I need two tings to make this work
1) navTabClass = the class name of the Tab section which could be on the div , ol or ul
2) navTabSelectedClass = the class name to indicate a tab is selected

 */
var navTabClass = 'TabNav';
var navTabSelectedClass = 'selectedTab';
var defaultTabId = 'defaultTab';

var preventDefaultEventonTabSelect = 1; // true==1 stop the url from being updated.


function showTab(e){
    var target, id, liElm, aElm, targetId; 
    elm = $(e);   
    // alert(elm.tagName);
    if (elm.tagName    == 'A' ) {   // in case the anchore link eack clicked
        liElm = elm.parentNode;
        aElm = elm ;
    }  else {   
        liElm = elm;
        aElm = elm.firstDescendant();   
    }
    target = aElm.readAttribute('href').strip();
    liElm.siblings().invoke('removeClassName', navTabSelectedClass); //de-select all tabs
    liElm.addClassName(navTabSelectedClass); // make our new tab selected
    if (target.startsWith('#'))  { //only if the anchor link is within the current document
        targetId = target.substring(1);
        var targetElm = $(targetId);  
        targetElm.siblings().invoke('hide');
        targetElm.show();           
    }
}

function showTabEvent(Event) {
    var elm = Event.element(); 
    showTab(elm);    
    if (preventDefaultEventonTabSelect) Event.preventDefault(); 
}

function markEvent(event) { // for debuging events
    var node = Event.element(event); // the node that was clicked on
    node.style.color = "green";
}

// this sets up the showTabEvent on the click events, after the dom has been loaded
document.observe('dom:loaded', function () {
    $$('.'+navTabClass+' li').each ( function (e)   {       
        e.observe('click',showTabEvent);   
        //      e.observe('click',markEvent);          
    } );
    if ($(defaultTabId) == null) { // if the default Tab Id is NOT used in the pages markup
        // set the default tab based on the first li of the list with the TabNav Class
        showTab($$('.'+navTabClass).first().firstDescendant());  
    }  else { // set the default tab based on the Id
        showTab($(defaultTabId));
    }    
})


function setNewStyleSheet (ss ) { 
    $$('link[rel="stylesheet"]').invoke('remove');
 
        $$('link[rel="stylesheet"]').invoke('remove');
        var attrs = {
            type 	: "text/css",
            href 	: ss,
            rel	:"stylesheet"
        };
 
        var sslink = new Element('link', attrs);
        $$('head').invoke('insert',sslink);

}