#!/usr/local/bin/perl
#
# MasterFeedback Version 2.6
# Created July 5, 1999
# Version 2.6 completed December 8, 2002
# Author: William Bontrager
# Email: william@willmaster.com
# Site: http://www.willmaster.com/
#
# Tech Support: http://willmaster.com/master/techsupport/
#
# Copyright 1998-2001 William Bontrager.
# Copyright 2002 Bontrager Connection, LLC.
#
# Before installing and/or using Master Feedback, 
# you must agree to the complete license agreement
# linked from http://willmaster.com/master 
#
#===============================

#    I N S T A L L A T I O N    I N S T R U C T I O N S
#
#
# (1) Make sure the first line, at the top of this file, points to Perl 5+ on your server.
#
#
# (2) Specify the directory location and name of the sendmail or qmail on your server.

$MailProgram = '/usr/sbin/sendmail';

#
# (3) This program is designed to help you spam-proof your site. As such, you do 
#     not need to have your email address anywhere in the form, not even in a 
#     hidden field, where email harvesting robots can grab it.
#
#     Instead of in the form, specify your email address here in the script.

$MyEmail = 'cyninthecity@chinohills.com,info@chinohills.com';

#
#
#  End of Installation Instructions.
#
# Please see the user's manual, MasterFeedbackManual.html, for additional instructions.
#
# Tech Support orientation at http://willmaster.com/master/techsupport/
#
#######################################################################################


sub ErrorHTML
{
	my $ts = join '<li>',@_;
	print "Content-type: text/html\n\n";
	print <<HTML;
<html><body bgcolor="white"><blockquote><blockquote>
<h4>Notice:</h4><ul><li>$ts</ul>
</blockquote></blockquote></body></html>
HTML
	exit;
} # sub ErrorHTML

sub Parse
{
	my $buffer;
	ErrorHTML('Form must use method "POST"') unless ($ENV{REQUEST_METHOD} eq 'POST');
	read(STDIN,$buffer,$ENV{CONTENT_LENGTH});
	my @p = split(/&/,$buffer);
	for(@p)
	{
		$_ =~ tr/+/ /;
		my ($n,$v) = split(/=/,$_);
		$n =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
		$v =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
		$v =~ s/(\<.*?)(embed|object|script|applet)(.*?\>)/${1}_${2}_$3/gis;
		$In{$n} = $v;
	}
} # sub Parse

sub DiscardExtraSpaces {my $s=$_[0];$s=~s/\A\s+//;$s=~s/\s+\Z//;$s=~s/\s\s+/ /g;return $s;}

sub ValidEmail
{
	return 0 if $_[0] =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)/;
	return 0 if $_[0] !~ /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,}|[0-9])(\]?)$/;
	return 1;
} # sub ValidEmail

Parse;
$MailProgram .= ' -t' if $MailProgram =~ /sendmail\Z/;
$In{realname} = $In{name} if $In{name};
ErrorHTML('A name must be provided.') unless $In{realname} =~ /\w/;
ErrorHTML('Please provide an email address.') unless $In{email};
ErrorHTML("The email address \&quot;$In{email}\&quot; appears to be invalid.") unless ValidEmail($In{email});
ErrorHTML("The name, \"$In{realname}\", appears to be incorrect. Maybe you typed an email address by mistake?") if $In{realname} =~ /\@/;
$In{realname} = DiscardExtraSpaces($In{realname});
$In{subject} = 'Master Feedback form submission' unless $In{subject};
if($In{email} =~ /(?:[\n\r]|%0[ad])b?cc\:.+\@.{4}/is)
{
	$In{email} =~ s/\@/AT/s;
	$In{email} =~ s/(?:[\n\r]|%0[ad])/\[LineBreak\]/sig;
}
if($In{subject} =~ /(?:[\n\r]|%0[ad])b?cc\:.+\@.{4}/is)
{
	$In{subject} =~ s/\@/AT/s;
	$In{subject} =~ s/(?:[\n\r]|%0[ad])/\[LineBreak\]/sig;
}
open MAIL,"|$MailProgram";
print MAIL <<TO_END;
Content-type: text/plain; charset="ISO 8859-1"
To: $MyEmail
From: "$In{realname}" <$In{email}>
Subject: $In{subject}

 Name: $In{realname}
Email: $In{email}
   IP: $ENV{REMOTE_ADDR}
 Form: $ENV{HTTP_REFERER}
Message:
$In{message}
-----
TO_END
for (sort keys %In)
{
	next unless /\AX[\_\-]/i;
	$tt = substr($_,2);
	print MAIL "$tt\: $In{$_}\n";
}
close MAIL;
unless($In{thankyou}) { $In{thankyou} = $In{redirect} ? $In{redirect} : $ENV{HTTP_REFERER}; }
print "Location: $In{thankyou}\n\n";
