#---------------------------------------------------------------------#
# If you're looking for where to configure Dada Mail, 
# you have landed in the correct location. 
#---------------------------------------------------------------------#
#
# How to install Dada Mail (easiest configuration):
#
# 	http://mojo.skazat.com/installation/
#---------------------------------------------------------------------#
#
# Advanced installation w/outside configuration file:
#
# 	http://mojo.skazat.com/purchase/sample_chapter-dada_mail_setup.html
#---------------------------------------------------------------------##
# Everything you ever wanted to know about configurating Dada Mail:
#
#	 http://mojo.skazat.com/support/documentation/Config.pm.html
#---------------------------------------------------------------------#
# When you are ready, 
# Scroll down for the 4 variables that you need to change. 
#
# Follow the instructions closely and this process should be pretty 
# easy. A few things before we get started:
#---------------------------------------------------------------------#
# * This is a Perl program,  so it follows certain programming 
# conventions. You can't just  put anything in this file and expect 
# it to work.
#---------------------------------------------------------------------#
# * The '#' (pound character) is used for commenting. Any line starting 
# with this character is used to write notes and comments. It 
# won't be seen to Perl as code and it is safe to write whatever 
# you want with, like this: 
# 
# 	# This is a comment. Yeee ha. 
#---------------------------------------------------------------------#
# * This file has documentation embedded in itself; if you're 
# looking at this sentence in anything other than the Config.pm file
# itself, the documentation has been extracted and saved somewhere else. 
# The documentation is called POD and looks like this: 
# 
# 	=pod 
# 	
# 	I am pod and I am OK.
# 	
# 	=cut
# 
# Exciting stuff, we know.
# 
#---------------------------------------------------------------------#
# Lastly, words that start with a '$' (dollar sign) are variables. 
# They're Perl code that stand for something else. You'll need to 
# change some variables (only 4) in this file to make Dada Mail
# work correctly. This will be the only file you'll need to change
# out of the whole bunch. To set up Dada Mail, follow the  
# instructions exactly. This file is HEAVILY commented to help you 
# along your way, be sure to read all the notes! :)  Scroll down 
# about 20 lines until you see the next group of comments to start 
# setting up Dada Mail. 
#---------------------------------------------------------------------#


# Almost there! Keep scrolling down... -V



package DADA::Config; 
require Exporter;  

@ISA = qw(Exporter); 

@EXPORT = qw($VER $PROGRAM_ROOT_PASSWORD $MAILPROG $FILES $PROGRAM_URL $S_PROGRAM_URL $MAIL_SETTINGS $FIRST_SUB $SEC_SUB @C $SALT $FILE_CHMOD $DIR_CHMOD $GIVE_PROPS_IN_EMAIL $GIVE_PROPS_IN_HTML $GIVE_PROPS_IN_ADMIN  $GIVE_PROPS_IN_SUBSCRIBE_FORM $SUBSCRIBED_MESSAGE $UNSUBSCRIBED_MESSAGE  $CONFIRMATION_MESSAGE  $HTML_CONFIRMATION_MESSAGE 
$YOU_ARE_ALREADY_SUBSCRIBED_MESSAGE $HTML_UNSUB_CONFIRMATION_MESSAGE $HTML_SUBSCRIBED_MESSAGE $HTML_UNSUBSCRIBED_MESSAGE $ARCHIVES  $TEMPLATES $ALTERNATIVE_HTML_TEMPLATE_PATH $TMP $LOGS $BACKUPS %BACKUP_HISTORY $FCKEDITOR_URL $SCREEN_CACHE $GLOBAL_BLACK_LIST $GLOBAL_UNSUBSCRIBE $GLOBAL_LIST_SENDING @PING_URLS $SUBSCRIPTION_SUCCESSFUL_COPY $MAILlING_LIST_MESSAGE $MAILlING_LIST_MESSAGE_HTML $ADMIN_MENU $NOT_ALLOWED_TO_POST_MESSAGE $PIN_WORD $PIN_NUM @DOMAINS %SERVICES $SHOW_DOMAIN_TABLE $SHOW_SERVICES_TABLE $SHOW_EMAIL_LIST $GOOD_JOB_MESSAGE  $NO_ONE_SUBSCRIBED  $ALLOW_ROOT_LOGIN $UNSUB_CONFIRMATION_MESSAGE 
@CHARSETS @PRECEDENCES @CONTENT_TYPES %LIST_SETUP_DEFAULTS %LIST_SETUP_INCLUDE %LIST_SETUP_OVERRIDES @SERVICES %PRIORITIES $ATTACHMENT_TEMPFILE $MAIL_VERP_SEPARATOR %MIME_TYPES $DEFAULT_MIME_TYPE $TEXT_INVITE_MESSAGE $HTML_INVITE_MESSAGE $MIME_PARANOID $MIME_HUSH $MIME_OPTIMIZE $NPH $PROGRAM_USAGE_LOG $ROOT_PASS_IS_ENCRYPTED @ALLOWED_IP_ADDRESSES $SHOW_ADMIN_LINK $ADMIN_FLAVOR_NAME $SIGN_IN_FLAVOR_NAME $DISABLE_OUTSIDE_LOGINS %LOG $DEBUG_TRACE %CPAN_DEBUG_SETTINGS $ADMIN_MENU $EMAIL_CASE @EMAIL_EXCEPTIONS  $LIST_IN_ORDER $ADMIN_TEMPLATE $USER_TEMPLATE $SUBSCRIBER_DB_TYPE $ARCHIVE_DB_TYPE $SETTINGS_DB_TYPE $SESSION_DB_TYPE 
%SQL_PARAMS $PROGRAM_ERROR_LOG $SHOW_HELP_LINKS $HELP_LINKS_URL $PROGRAM_NAME @CONTENT_TRANSFER_ENCODINGS $PROGRAM_CONFIG_FILE_DIR $OS $DEFAULT_ADMIN_SCREEN $DEFAULT_LOGOUT_SCREEN $DEFAULT_SCREEN $HTML_CHARSET $HTML_SEND_ARCHIVED_MESSAGE $SEND_ARCHIVED_MESSAGE $REFERER_CHECK $GD_SECURITYIMAGE_PARAMS $LOGIN_COOKIE_NAME %COOKIE_PARAMS %HTMLFROMTEXT_OPTIONS $LOGIN_WIDGET $NULL_DEVICE $LIST_QUOTA $SUBSCRIPTION_QUOTA %EMAIL_HEADERS @EMAIL_HEADERS_ORDER);
 
use vars qw(@EXPORT  $VER $PROGRAM_ROOT_PASSWORD $MAILPROG $FILES $PROGRAM_URL $S_PROGRAM_URL $MAIL_SETTINGS $FIRST_SUB $SEC_SUB @C $SALT $FILE_CHMOD  $DIR_CHMOD $GIVE_PROPS_IN_EMAIL $GIVE_PROPS_IN_HTML $GIVE_PROPS_IN_ADMIN $GIVE_PROPS_IN_SUBSCRIBE_FORM $SUBSCRIBED_MESSAGE $UNSUBSCRIBED_MESSAGE  $CONFIRMATION_MESSAGE  $HTML_CONFIRMATION_MESSAGE 
$YOU_ARE_ALREADY_SUBSCRIBED_MESSAGE $HTML_UNSUB_CONFIRMATION_MESSAGE $HTML_SUBSCRIBED_MESSAGE $HTML_UNSUBSCRIBED_MESSAGE $ARCHIVES  $TEMPLATES $ALTERNATIVE_HTML_TEMPLATE_PATH $TMP $LOGS  $BACKUPS %BACKUP_HISTORY $FCKEDITOR_URL $SCREEN_CACHE $GLOBAL_BLACK_LIST $GLOBAL_UNSUBSCRIBE $GLOBAL_LIST_SENDING @PING_URLS $SUBSCRIPTION_SUCCESSFUL_COPY $MAILlING_LIST_MESSAGE $MAILlING_LIST_MESSAGE_HTML $ADMIN_MENU $NOT_ALLOWED_TO_POST_MESSAGE $PIN_WORD $PIN_NUM @DOMAINS %SERVICES $SHOW_DOMAIN_TABLE $SHOW_SERVICES_TABLE $SHOW_EMAIL_LIST $GOOD_JOB_MESSAGE  $NO_ONE_SUBSCRIBED  $ALLOW_ROOT_LOGIN $UNSUB_CONFIRMATION_MESSAGE 
@CHARSETS @PRECEDENCES @CONTENT_TYPES %LIST_SETUP_DEFAULTS %LIST_SETUP_INCLUDE %LIST_SETUP_OVERRIDES @SERVICES %PRIORITIES $ATTACHMENT_TEMPFILE $MAIL_VERP_SEPARATOR %MIME_TYPES $DEFAULT_MIME_TYPE $TEXT_INVITE_MESSAGE $HTML_INVITE_MESSAGE $MIME_PARANOID $MIME_HUSH $MIME_OPTIMIZE $NPH $PROGRAM_USAGE_LOG $ROOT_PASS_IS_ENCRYPTED @ALLOWED_IP_ADDRESSES $SHOW_ADMIN_LINK $ADMIN_FLAVOR_NAME $SIGN_IN_FLAVOR_NAME $DISABLE_OUTSIDE_LOGINS %LOG $DEBUG_TRACE %CPAN_DEBUG_SETTINGS $ADMIN_MENU $EMAIL_CASE @EMAIL_EXCEPTIONS $LIST_IN_ORDER $ADMIN_TEMPLATE $USER_TEMPLATE $SUBSCRIBER_DB_TYPE $ARCHIVE_DB_TYPE $SETTINGS_DB_TYPE $SESSION_DB_TYPE 
%SQL_PARAMS $PROGRAM_ERROR_LOG $SHOW_HELP_LINKS $HELP_LINKS_URL $PROGRAM_NAME @CONTENT_TRANSFER_ENCODINGS $PROGRAM_CONFIG_FILE_DIR $OS $DEFAULT_ADMIN_SCREEN $DEFAULT_LOGOUT_SCREEN $DEFAULT_SCREEN $HTML_CHARSET $HTML_SEND_ARCHIVED_MESSAGE $SEND_ARCHIVED_MESSAGE $REFERER_CHECK $GD_SECURITYIMAGE_PARAMS $LOGIN_COOKIE_NAME %COOKIE_PARAMS %HTMLFROMTEXT_OPTIONS $LOGIN_WIDGET $NULL_DEVICE $LIST_QUOTA $SUBSCRIPTION_QUOTA %EMAIL_HEADERS @EMAIL_HEADERS_ORDER); 
 
use strict; 
 
 
=pod

=head1 NAME Config.pm 

=head1 DESCRIPTION 

The Config.pm file holds all the variables needed to make 
global changes in Dada Mail. 

=head1 Dada Mail Set Up Instructions

You'll need to change 4 variables to get Dada Mail up and
running. We've numbered them and provided help on the way, so let's 
start! People who are upgrading from previous versions will be able 
to use most of the same variable values as they've done before. 


=head2 $PROGRAM_ROOT_PASSWORD

(1) Make a Dada Mail Root Password. This is used to Create New Lists.
Tip -> make this somewhat obscure, and do not use "dada" or 
"root_password" or "god" or "money" or "mail". 

=cut

# Change! The Root Password below: 
#
$PROGRAM_ROOT_PASSWORD = 'XKiPkDmMLQXUo';
#

=pod

Tip -> Comment the above line like this:

	#$PROGRAM_ROOT_PASSWORD = 'root_password';

to totally disable new list creations. If you're not going to create 
new lists for a while, we suggest you comment that line for security 
reasons. 

We also beg, plead and warn you that you really really should
encrypt this password, by following the instructions located near the
$ROOT_PASS_IS_ENCRYPTED variable. 


=head2 $FILES

(2) What is the Absolute Path the lists are going to be stored in? 
It's a good idea to store this information somewhere OTHER than under 
your public_html directory, to guarantee that no list information can 
be seen via a Web browser. You may have to chmod 777 this directory, 
or your cgi script won't be able to write new files to it. 777 is very 
open to outside eyes, so if you can, always set this to the minimum 
permission needed! 

=cut

# Change! The absolute path to where your list information is saved  below:
#
$FILES = '/home/joezeppy/skazat';
#

=pod

=head2 $MAILPROG

(3) What is the Absolute Path of your mail program?
To find out, type in "which sendmail" in a telnet session.
If you don't have sendmail, this script will still work great,
but you may have to fiddle around with the "$MAIL_SETTINGS"
variable under the "additional settings" after the first four 
variables. Dada Mail uses a Mail Program like Sendmail or qmail to
send its messages and it needs to know where the Mail Program is 
to be able to use it. 

=cut

# Change! Where you mail program is (you may not need to!) below:
# 
$MAILPROG = '/usr/sbin/sendmail';  
#

=pod


=head2 $PROGRAM_URL

(4) What is the URL of the mail.cgi script? 
This is the address of the mail.cgi script (not this file!), 
so when you're all done setting up the script, you'll have to go 
here to make your first list. 

=cut

# Change! The URL to your Dada Mail below:
#
$PROGRAM_URL ='http://www.chinohills.com/cgi-bin/dada/mail.cgi';
#

=pod

That's it, you're done! It's recommended that you set up at least 
one list to see if everything is working correctly and then fix 
problems (if any) that you find. All other variables either don't 
need to be changed or are advanced settings. Your error log is a 
great place to start figuring out what went wrong. If you don't 
have access to an error log, scroll through this file to see how to 
create an error log just for Dada Mail.

Here's a check-off list to make sure you've installed everything 
correctly. This list is somewhat long and exhaustive, as it covers 
most frequently asked questions that can be fixed in this file. 

=over

=item *

If you are upgrading from Dada Mail 2.x, it's well advised that you 
first test this version in a different directory and see if it's
working. Lists made with previous versions of Dada Mail 2.x will 
work with this version and lists generated using this version 
will also be compatible with any previous 2.x versions. 

=item *

Upload the mail.cgi script _and_ the DADA folder (both as text,
NOT binary). If you are upgrading from a previous version of 
Dada Mail 2.x, you'll need to replace the entire DADA folder. 
Make sure you upload everything that's in the DADA folder, even 
the Mail and MIME folders.

=item *

chmod 755 the mail.cgi script. Nothing needs to be changed 
permissions-wise in the DADA folder. Make sure you save the 
Config.pm file (this file!) and make sure that you put it back 
in the DADA folder. 

=item *

Run Dada Mail by going to the URL that you put in the 
'$PROGRAM_URL' variable. If you don't see anything, or get a 404, 
you're probably using the wrong address. Some hosting services
put the cgi-bin in a weird spot and you'll need a special 
address. 

=item *

If, when making a new list, everything seems to work but Dada 
Mail isn't saving any information, make sure that there exists
a directory you've specified in the '$FILES' variable, and make
sure you can write to that directory. You may need to chmod 777
that directory. Usually setting this variable to be somewhere 
in your cgi-bin is NOT A GOOD IDEA. Sometimes you cannot 
write files into your cgi-bin anyways.      

=item *

If everything is working well except no mail is being sent, 
(not a good thing for a Mailing List Program!) you may have to
fiddle with the $MAIL_SETTINGS variable, located farther down
this file, or make sure that you have the correct address in the
$MAILPROG variable.

=item *

All other variables below don't need to be changed to have 
Dada Mail run incredibly. They're provided to allow you to 
tweak the program to your liking. We tried to make the program
a breeze to set up and to also make it customizable. Not an 
easy task. 

=back

Check out the support section on the Dada Mail website: 

http://mojo.skazat.com/support 

if you have any more questions.

B<One last note:> 

Always Always Always set up a test list. Mailing List Managers are 
almost always in a critical state, since who knows how many 
thousands of people are interacting with your lists? Will this 
sending option work well? at all? Test. Test. Test. Test. You may 
want to read this entire file to get familiar with what Dada Mail
does. Actually no: I really want you to read this entire file to 
get familiar with Dada Mail. It may take you a minute, but it will 
save you time in the future. 

B<Another last note:>

This file is going to be your best friend. It's chock full of 
information, advice, and ideas. Use it!

=cut


=pod

=head1 Additional Settings

It's well advised that you get familiar with this program and
go through it ENTIRELY before you change any of the settings below. 
From this point, it helps if you have some kind of Unix/Perl 
background, Or you've used previous versions of the script. 

=cut

$PROGRAM_CONFIG_FILE_DIR = undef; 

#------------------
#leave this alone | 
 _config_import();
#------------------


=pod

=head2 $S_PROGRAM_URL

The "S" in $S_PROGRAM_URL stands for B<S>ecure, and allows you to 
have all screens that have anything to do with the list control 
panel to use a separate URL where you can install a completely 
different version of Dada Mail, or, if you can access your website 
via the https protocol, you can use that different URL specifically 
for list control panel activity. 

Make sure $S_PROGRAM_URL contains a valid URL (http://...). 

=cut

$S_PROGRAM_URL ||= $PROGRAM_URL;


=pod

=head2 $SUBSCRIBER_DB_TYPE

B<$SUBSCRIBER_DB_TYPE> specifies the database you'd like to be using. The 
plain-as-grain one to use is 'PlainText', although others may be 
available and you may be so inclined to make your own. B<MySQL> and 
B<PostgreSQL> should be included in the standard distribution. To be 
able to use any SQL backend requires that you have access to an SQL 
database and that you have the B<DBI> perl modules installed. 

Set $SUBSCRIBER_DB_TYPE to B<MySQL> for MySQL, B<PostgreSQL> for Postgres.

If you do use a SQL database, you most likely have to tweak
the B<%SQL_PARAMS> hash. 

=cut

$SUBSCRIBER_DB_TYPE         ||= 'PlainText'; 


=pod

=head2 $ARCHIVE_DB_TYPE

Similar to $SUBSCRIBER_DB_TYPE, I<$ARCHIVE_DB_TYPE> refers to what database type 
you'd like to be using for Dada Mail's archives. The default is 
B<Db>, which refers to the DB File format (The Berkeley DB_File format).

Available also are B<MySQL> and B<PostgreSQL>.

Set $ARCHIVE_DB_TYPE to B<MySQL> for Mysql, B<PostgreSQL> for Postgres.

If you do use a SQL database, you most likely have to tweak
the B<%SQL_PARAMS> hash. 

=cut

$ARCHIVE_DB_TYPE  ||= 'Db'; 


=pod

=head2 $SETTINGS_DB_TYPE

Similar to $SUBSCRIBER_DB_TYPE, I<$SETTINGS_DB_TYPE> refers to what database type 
you'd like to be using for Dada Mail's archives. The default is 
B<Db>, which refers to the DB File format (The Berkeley DB_File format).

Available also are B<MySQL> and B<PostgreSQL>.

Set $SETTINGS_DB_TYPE to B<MySQL> for Mysql, B<PostgreSQL> for Postgres.

If you do use a SQL database, you most likely have to tweak
the B<%SQL_PARAMS> hash. 

=cut




$SETTINGS_DB_TYPE ||= 'Db'; 



=pod

=head2 $SESSION_DB_TYPE

Similar to $SUBSCRIBER_DB_TYPE, etc, I<$SESSION_DB_TYPE> refers to what database type 
you'd like to be using for Dada Mail's admin control panel session. These 
sessions keep track of who's logged into what, and their credentials. 

The default is B<PlainText>. 

Available also are B<MySQL>, B<PostgreSQL>,  B<Db> (For the Berkeley DB) and also, 
B<Classic>, which isn't really a backend at all, but is actually the Old Way of doing things.

The Old Way of doing things is to keep the list you're using and the password (encrypted, of course),
in the login session cookie itself. The other ways only save a session id - which is then used to
fetch the list and password (again encrypted) from the server itself. The Classic way of doing things
has the problem that the password, even encrypted, leaves the server environment, and leaves within 
your cookie. Not the best idea, so only use the Classic way, if there is simply no other way to make 
this work and understand the limitations of using the Old, Class Way. 

If you do use a SQL database, you most likely have to tweak
the B<%SQL_PARAMS> hash. 

=cut



$SESSION_DB_TYPE ||= 'PlainText'; 


=pod

=head2 %SQL_PARAMS

B<%SQL_PARAMS> are parameters passed to the SQL server. You need to 
fill these out if you're using either MySQL or PostgreSQL. (You also 
need to make a table for Dada Mail to work with, explained later.) 
They are as follows: 

=over

=item database

The name of the database you are using.

=item dbserver 

The name of the database server itself. Example: I<sql.mydomain.com>

=item port 

The port that is used when connecting to the database server. You usually
only need this for Postgres.

=item dbtype

Set dbtype to 'mysql' for MySQL usage, 'Pg' for Postgres.

=item user

The SQL username.

=item pass 

The SQL password.

=back

Before trying to install Dada Mail with an SQL backend, make sure you 
create the appropriate table. For MySQL users, make the table using this:

 CREATE TABLE dada_subscribers (
 email_id                         int4 not null primary key auto_increment,
 email                            text,
 list                             text,
 list_type                        text,
 list_status                      char(1)
 ); 

For Postgres, use this: 

 CREATE TABLE dada_subscribers (
 email_id                         serial,
 email                            text,
 list                             text,
 list_type                        text,
 list_status                      char(1)
 );

If you are setting $ARCHIVE_DB_TYPE to an SQL, also issue one of the following tables - 

For MySQL users, use this table: 

 CREATE TABLE dada_archives (
 list                             varchar(32),
 archive_id                       varchar(32),
 subject                          text,
 message                          mediumtext,
 format                           text,
 raw_msg                          mediumtext
 );


For Postgres, use this: 


 CREATE TABLE dada_archives (
 list                             varchar(32),
 archive_id                       varchar(32),
 subject                          text,
 message                          text,
 format                           text,
 raw_msg                          text
 );

B<Note!> that the table schema for Archives has changed for version 2.9 or later - 
if you're upgrading, make sure your table now matches the new schema. 

If you are setting $SETTINGS_FB_TYPE to an SQL, also issue this table (will work for both MySQL and Postgres)

 CREATE TABLE dada_settings (
 list                             text,
 setting                          text,
 value                            text 
 );

Finally, if you are setting, B<$SESSION_DB_TYPE> to an SQL, issue one of these tables: 

For MySQL users, use this table: 

 CREATE TABLE dada_sessions (
    id CHAR(32) NOT NULL PRIMARY KEY,
    a_session TEXT NOT NULL
 );

For Postgres, use this: 

 CREATE TABLE dada_sessions (
    id CHAR(32) NOT NULL PRIMARY KEY,
    a_session BYTEA NOT NULL
 );

=cut

%SQL_PARAMS = ( 
database         => '',
dbserver         => '', # may just be, "localhost"   	   
port             => '', # mysql: 3306, Postgres: 5432   	   
dbtype           => '', # 'mysql' for 'MySQL', 'Pg' for 'PostgreSQL'  
user             => '',          
pass             => '',

subscriber_table => 'dada_subscribers',
archives_table   => 'dada_archives', 
settings_table   => 'dada_settings', 
session_table    => 'dada_sessions', 


) unless keys %SQL_PARAMS; 


=pod

=head1 Security 

This section deals with Dada Mail and security - both to tighten it
up and lax it down, depending on what you want to allow and what 
you can do. 

=head2 $SHOW_ADMIN_LINK

Set $SHOW_ADMIN_LINK to '0' to take off the 'Administration' link
that you see on the Dada Mail default page. You can always get to 
the administration page by pointing your browser to an address 
like this: 

	http://mysite.com/cgi-bin/dada/mail.cgi?f=admin

This is a small security measure but may just stop people from 
snooping further. 

=cut

$SHOW_ADMIN_LINK ||= 1;


=pod 

=head2 $ADMIN_FLAVOR_NAME

Complementary to the B<$SHOW_ADMIN_LINK> variable, B<$ADMIN_FLAVOR_NAME> allows you to set the URL needed to access the screen that has the form to log into all the lists administrated by Dada Mail and to the form to create a new list. 

By default, this variable is set to, B<admin>, which means to access this screen, you'd go to a URL that looks like this: 

http://example.com/cgi-bin/dada/mail.cgi?flavor=admin

or: 

http://example.com/cgi-bin/dada/mail.cgi?f=admin

or: 

http://example.com/cgi-bin/dada/mail.cgi/admin

If you set B<$ADMIN_FLAVOR_NAME> to something like, B<kookoo>: 

 $ADMIN_FLAVOR_NAME ||= 'kookoo'; 

You'd then access this screen via the following URLS; 

http://example.com/cgi-bin/dada/mail.cgi?flavor=kookoo

or: 

http://example.com/cgi-bin/dada/mail.cgi?f=kookoo

or: 

http://example.com/cgi-bin/dada/mail.cgi/kookoo

A small security measure for sure, but could help keep curious eyes at bay. 

Works best if you have, B<$SHOW_ADMIN_LINK> set to, B<1>. 

A small note on how to set this variable correctly: 

=over

=item * no spaces in the name

Valid values: 

=over

=item * poopoo1234

=item * agabaga

=item * JKdsfkKJjjkkjjk

=back

Invalid values: 

=over

=item * fads fdas    asdf

=item * You Get The Point

=back

=item * Don't set this variable to anything that Dada Mail already uses, like:

=over

=item * subscribe

=item * unsubscribe

=item * login

=item * logout

=item * list

=item * archive

=back

etc. A good way to make sure would be to append, "admin" to your value, like this: 

=over

=item * adminfoofoo

=item * adminlalalala

=item * adminwhakawhaka

=back

No checks will be made to make sure you don't have this value set to something already present, so do be careful setting this variable. 


=back

=cut


$ADMIN_FLAVOR_NAME ||= 'admin'; 


=pod

=head2 $SIGN_IN_FLAVOR_NAME

Similar to B<$ADMIN_FLAVOR_NAME>, B<$SIGN_IN_FLAVOR_NAME> holds the URL that allows you to log into a particular list (usually), although it is sometimes used to re-login into any of your lists - very similar to the administration screen, but does not give you the form to create a new list. 

The same naming rules apply for this variable as they do for B<$ADMIN_FLAVOR_NAME>. It's also suggested that you append, "sign_in" to the value you set this, like so: 

=over

=item * sign_in_fdskjasdf

=item * sign_in_sneaky_pete

=back

etc. 

=cut


$SIGN_IN_FLAVOR_NAME ||= 'sign_in'; 


=pod

=head2 $DISABLE_OUTSIDE_LOGINS

If set to, B<1>, The only forms that will allow you to log into a Dada Mail list will be by 
a form supplied by Dada Mail itself. This means, you can't create a different form, outside
the program to provide a way to login. 

More so than any other option, this variable attempts to stop attempts of logging into a list
by automated means. 

=cut


$DISABLE_OUTSIDE_LOGINS ||= 0; 


=pod 

=head2 $LOGIN_WIDGET

By default on the list login screen, Dada Mail presents its user 
with a popup menu with the names of all the lists, hidden or not, that 
you can select to login to. 

This is done by setting B<$LOGIN_WIDGET> to 'popup_menu'. 

If you want to only have a text box for someone to type in the 
list Short Name in, set B<$LOGIN_WIDGET> to 'text_box'.

=cut


$LOGIN_WIDGET ||= 'popup_menu'; 


=pod

=head2 $ALLOW_ROOT_LOGIN

B<Allow the Root Password to Log In to All Lists>

Set the '$ALLOW_ROOT_LOGIN' variable to '1' to allow the Dada Root
Administrator to use the dada root password to log into any list. 
This is handy when you have many, many lists and need to tweak them 
but don't want to keep track of all the list passwords. Setting 
this variable to '1' does make your lists less secure, as every list 
can be accessed with the same password and that password is 
written plainly in this file, unless! you encrypt it (see below).

=cut

$ALLOW_ROOT_LOGIN ||= 1; 


=pod

=head2 $ROOT_PASS_IS_ENCRYPTED

You can store an encrypted version of the $PROGRAM_ROOT_PASSWORD 
instead of the plain text version. Here are the steps. This is 
B<extremely> recommended for obvious reasons.

=over

=item 1

Set up Dada Mail so it's working. Usually this means setting up 
the first four variables. 

=item 2

Point your browser to wherever you have the dada.cgi script at, and 
at the end of the URL, append this: ?f=pass_gen so you'll have 
something that looks like this: 

	http://yoursite.com/cgi-bin/dada/mail.cgi?f=pass_gen

=item 3

You'll see a page in your browser that asks for a password to 
encrypt. Type in the password you want to use, and press 'encrypt'. 
An encrypted password will be outputted. 

=item 4

Copy that encrypted password and use it as the root password (that is, 
by changing the $PROGRAM_ROOT_PASSWORD variable above to the 
encrypted password).

=item 5

Set $ROOT_PASS_IS_ENCRYPTED below to '1'.

=cut

$ROOT_PASS_IS_ENCRYPTED ||= 1;

=pod

=item 6 

Eat a mango. They're REALLY good.

=back 


=head2 @ALLOWED_IP_ADDRESSES

You can block anyone from using any list control panel by 
specifying exactly what IP addresses are allowed. Leave the 
@ALLOWED_IP_ADDRESSES blank:

	@ALLOWED_IP_ADDRESSES = qw(); 

to disable this security measure. 

To add an address, just list it, like this: 
	
	@ALLOWED_IP_ADDRESSES = qw(123.456.67.678 
	                           215.234.56.9 
	                           783.456.9.2);

=cut

@ALLOWED_IP_ADDRESSES = qw() 
	unless scalar @ALLOWED_IP_ADDRESSES;

=pod

Please note that crafty people can spoof what IP address they're 
coming from, and dial-up accounts and connections using DHCP may
not have the same IP address per session.  


=head2 $REFERER_CHECK

Setting $REFERER_CHECK to '1' will only allow you to access admin
screens if the referer in your web browser is whatever is set in 
$PROGRAM_URL or $S_PROGRAM_URL. In other words, you won't be able to 
sign in to your list control panel, then stop, check your email on 
Yahoo! and come back to the list control panel by typing in its URL. 

=cut

$REFERER_CHECK ||= 0; 

=pod

=head2 CAPTCHA Configuration ($GD_SECURITYIMAGE_PARAMS)

See: 

http://search.cpan.org/~burak/GD-SecurityImage/lib/GD/SecurityImage.pm

For information, 

Each key in this hashref corresponds to the different methods of this module ie:

=over

=item * new

=item * create

=item * particle

=back


=cut


$GD_SECURITYIMAGE_PARAMS = { 

    'rand_string_from' => 'ABCDEFGHIJKLMNOPQRSTUVWXYZaeiouy', 
    'rand_string_size' => 6, 
    

    'new' => { 
    
        width      => 250,
        height     => 125,
        lines      => 10,
        #gd_font    => 'Giant',
        send_ctobg => 1, 
        
        # There's some magic here, 
        # If the font is located in the, 
        # dada/DADA/Template/templates directory, 
        # You don't have to put the absolute path, 
        # just the filename. 
        
        font       => 'StayPuft.ttf', 
        bgcolor    => "#CCFFCC",
        angle      => 13, 
        ptsize     => 30,
                                          
    
    }, 
    
    create => {
    
       ttf => 'circle',
       # normal => 'circle',      
    }, 
    
    particle => [
        500, 
        undef
    ], 

}; 





=pod

=head1 Cookies

Dada Mail uses cookies only for its login mechanism. 
Subscribers are not given a cookie. 


=head2 $LOGIN_COOKIE_NAME

B<$LOGIN_COOKIE_NAME> holds the name of the cookie passed to 
the person's browser that will be accessing the list control 
panel. 

=cut

$LOGIN_COOKIE_NAME ||= 'dadalogin';


=pod

=head2 Cookie Parameters 

Some browsers/servers funkify Dada Mail's cookies. I don't know why.
You can set additional attributes that are written for Dada Mail 
cookies by tweaking the %COOKIE_PARAMS hash, as outlined: 

http://search.cpan.org/author/JHI/perl-5.8.0/lib/CGI.pm#HTTP_COOKIES

=cut

%COOKIE_PARAMS = (
                  -path    => '/',
                  -expires => '+1d', 
                 
                 ) unless keys %COOKIE_PARAMS; 


=pod

=head1 Sendmail Settings


=head2 $MAIL_SETTINGS

B<|$MAILPROG -t -odq> is great to use for very large lists as it 
queues up all messages, but may not be available in all situations.

Since Dada Mail 2.4, most optional flags aren't needed, as Dada Mail now 
handles the mailing of large lists well with its Batch Sending feature
and sending mail through SMTP. These settings are still useful if you 
are using something other than Sendmail or qmail. 

See the main page for Sendmail or whatever mail system 
your server uses for more info.
Some flags for sendmail you can use are:

-io    -> Not exit a line with only a dot is read.

-t     -> Read the headers of the message to decide whom to send it to. 
          (this is really good to have for qmail)   

-odq   -> Insert the message into a queue. 

-oem   -> On error, mail back the message 
          attempting to deliver it immediately.  

An example of using all those flags in the variable looks like this: 

    $MAIL_SETTINGS = "|$MAILPROG -oi -t -odq -oem";

Tip: change this to ">>filename.txt";
to make Dada send email to a file instead of an email, for debugging.
Here's something to look at: 
http://www.courier-mta.org/sendmail.html
if you want more info.

=cut

$MAIL_SETTINGS ||= "|$MAILPROG -t";


=pod

=head1 Windows-Specific Settings


=head2 $NPH

NPH stands for No Parse Headers. I don't know what that means either, 
but Microsoft servers like it, and I've found that cookies don't get 
set correctly and you're left with a funky screen saying you did 
wrong without it. Set this variable to '1' if you're using a Windows 
server. 

=cut

$NPH ||= 0; 

=pod

It's also a good idea to rename dada nph-dada.cgi for Windows servers 
that require scripts to use NPH.

=cut


=pod

=head1 Logging


=head2 $LOGS

$LOGS sort of holds the default location of where all the logs should 
be placed; you can then set the other logs using this as a starting 
point. For example: 

 $LOGS = '/home/account/dada_files/logs';  
 
 $PROGRAM_USAGE_LOG = $LOGS . '/usage.txt'; 

Sneaky. This makes a bit more sense if you're using an outside 
configuration file. 

=cut

$LOGS      ||= $FILES;


=pod

=head2 $PROGRAM_USAGE_LOG

The dada log keeps track of mundane things, such as subscriptions, 
unsubscriptions, control panel logins, ...things like that. 
This can be pretty useful come debugging time, or if something went 
south during a very important mailing - best to turn this on 
/before/ that big mailing. 

Turn logging on by specifying a absolute path to a file you want 
to use for the log. I personally always have this on, since it helps
in finding a general trend and health of my list and can be beneficial
if there is some sort of subscription dispute. 

=cut

$PROGRAM_USAGE_LOG ||= $LOGS . '/dada_usage.txt';


=pod

=head2 %LOG

What should be logged?

Change each value to '1' in the %LOG hash if you want these things 
logged, change the variable to a '0' if you don't. 

=cut

# log subscriptions/unsubscriptions? 
$LOG{subscriptions} ||= 1; 

# log regular mailings? 
$LOG{mailings} ||= 0; 

# log mass mailings? 
$LOG{mass_mailings} ||= 1;

# log batchess of mass mailings? 
$LOG{mass_mailing_batches} ||= 1;

# log control panel login/logouts? 
$LOG{logins} ||= 1; 

# log new lists created/old lists destroyed?
$LOG{list_lives} ||= 1;

=pod

=head2 $DEBUG_TRACE

Not currently implemented, but B<$DEBUG_TRACE> will allow you to set various error log tracing options.  

=cut

$DEBUG_TRACE = { 

    
    DADA_Mail_MailOut => 0, 
      
};




=pod

=head2 $PROGRAM_ERROR_LOG

If you want to set a specific location for all errors from Dada Mail to be 
logged, B<$PROGRAM_ERROR_LOG> is what you want to look at. 

Set this variable to, B<An absolute path, to a location of a file you want
the error log to be>. Sounds like a mouthful - let's break it down:

=over

=item * "An absolute path" -  the path to a resource on the server, from the server's perspective. (begin geekery:)

In a Unix environment, an absolute path starts with, "B</>", also known as the, "root" directory and moves
down, like an upside-down tree. Example of some absolute paths: 

=over

=item * /home/myaccount

an example of the absolute path to my home directory

=item * /home/myaccount/dada_files

an example of the absolute path to where I've set the, B<$FILES> variable to (just as example). 

So, if you've set the B<$FILES> variable correctly, you already know what absolute paths are. You see? You're smarter than you thought. 

=back

=item * "to a location of a file you want the error log to be"

So what's , "an error log"? It's just a plain text file - that's it, so set the B<$PROGRAM_ERROR_LOG> variable to an absolute path to a plaintext file. Easy enough. As to, "I<what> location"? Well, if you've set the B<$FILES> variable to an absolute path of a directory (per directions), use that as a starting point, and just specify an exact file in that directoy - easy! 

=back

So, if I set B<$FILES> to: 

 $FILES = '/home/myaccount/dada_files'; 

set, B<$PROGRAM_ERROR_LOG> to: 

 $PROGRAM_ERROR_LOG = 'home/myaccount/dada_files/errors.txt'; 

and you're done. 

B<Note!> This B<WILL NOT> work: 
 
 $PROGRAM_ERROR_LOG = $FILES . '/errors.txt'; 

So, don't do that. 

Also, you cannot set this variable in an outside configuration file (.dada_config), it has to be set in the Config.pm file. 

Finally, just to clarify, the program can't automatically set a error log, since there may be problems with the program, before it's able to be fully interpreted, so we have to hard code it, that's why there's this variable. 

=cut

BEGIN {

# Type in the absolute path of the file you want to make as your 
# error log for Dada Mail.
# You CANNOT have this variable in an outside config file - 
# it MUST be set here. 

$PROGRAM_ERROR_LOG = undef; 


# Keep this next bit as-is; it's just opening the error file for writing. 
if($PROGRAM_ERROR_LOG){open (STDERR, ">>$PROGRAM_ERROR_LOG") 
	|| warn "$PROGRAM_NAME Error: Cannot redirect STDERR, it's possible that Dada Mail does not have write permissions to this file ($PROGRAM_ERROR_LOG) or it doesn't exist! If Dada Mail cannot make this file for you, create it yourself and give it enough permissions so it may write to it: $!";}
	# chmod(0777, $PROGRAM_ERROR_LOG); 
	# uncomment the above line, if the user that runs Dada Mail in your web 
	# browser is different than what's used to run Dada Mail via something 
	# like a cronjob. If you're not using a cronjob or running anything of 
	# Dada Mail via the commandline, don't worry about uncommenting this line. 
	}  

=pod 

=head2 %CPAN_DEBUG_SETTINGS 

Control what outside CPAN modules give back debugging information. 
Set the value to, "1" to enabled debugging information from the CPAN module.

Example: 

 NET_SMTP => 1,

Read the inline comments - there may be instances where you can set these values
to something other than, "1" if the CPAN module itself supports levels of debugging
information (for example:DBI)

=cut

%CPAN_DEBUG_SETTINGS = (

    # DBI, handles all SQL database calls. 
    # More Information: 
    # http://search.cpan.org/~timb/DBI/DBI.pm#TRACING
    # As noted in these docs, you can set the trace level as far 15
    
    DBI => 0, 


    
    # HTML::Template, used for generating HTML screens
    # More information: 
    # http://search.cpan.org/~samtregar/HTML-Template/Template.pm

    HTML_TEMPLATE => 0,   


    
    # MIME::Lite::HTML, used for the, "Send a Webpage" screen
    # More information:
    # http://search.cpan.org/~alian/MIME-Lite-HTML/HTML.pm
    
    MIME_LITE_HTML => 0, 
    
  
    
    # Net::POP3, used for checking awaiting messages on a POP3 Server
    # More Information: 
    # http://search.cpan.org/~gbarr/libnet/Net/POP3.pm
    
    NET_POP3 => 0, 
    
    
    
    # Net::SMTP, used for sending messages via SMTP: 
    # more information:
    # http://search.cpan.org/~gbarr/libnet/Net/SMTP.pm
    
    NET_SMTP => 0, 
    
    
    
) unless keys %CPAN_DEBUG_SETTINGS;




=pod

=head1 Templates 							

You can change the look and feel of Dada Mail globally by specifying a
different template file to use. Examples of what these templates 
look like are located in the 'extras' directory. 


=head2 $ADMIN_TEMPLATE

Path to the admin template. The default admin template is located at: 

 dada/DADA/Template/templates/default_admin_template.tmpl

=cut

$ADMIN_TEMPLATE ||= ''; 


=pod 

=head2 $USER_TEMPLATE

Path to the default user template, also know as the list template. 
We'll attempt to stick to one name from now on. The default user/list 
template is located at: 

dada/DADA/Template/templates/default_list_template.tmpl

=cut

$USER_TEMPLATE  ||= ''; 


=pod

=head1 List Files - Specific Places to Write Them


=head2 $TEMPLATES

Templates, by default, are saved in the same directory as your lists. 
To make things cleaner and nicer, you can move them into their own 
directory by setting the B<$TEMPLATES> variable to an absolute path to 
a directory.

=cut

$TEMPLATES ||= $FILES; 


=pod

=head2 $ALTERNATIVE_HTML_TEMPLATE_PATH

Hopefully, this variable will not need to be used - it's a little 
confusing on what it does.... 

Dada Mail, internally, uses a separate templating language from what 
is exposed to list owners and such, called HTML::Template. 
More information:

http://search.cpan.org/~samtregar/HTML-Template-2.7/Template.pm

Dada Mail needs to know the absolute path to these templates, which 
(as of 2.9) is at: 

 /path/to/your/cgi-bin/dada/DADA/Template/templates

Sometimes, the automated thingy that figures this absolute path hangs 
for unknown reasons. 

To thwart that, you can manually put the absolute path you need in 
B<$ALTERNATIVE_HTML_TEMPLATE_PATH> like so: 

 $ALTERNATIVE_HTML_TEMPLATE_PATH = '/home/justin/cgi-bin/dada/DADA/Template/templates'; 

How do you know if you need to set this variable? Most likely, you'll 
get an error that contains something along the lines of: 

 HTML::Template::Expr->new() : Error creating HTML::Template object :   HTML::Template->new() : Cannot open included file congrats_screen.tmpl : file  not found. at

or something dealing with the "File::Spec" module. 

Somewhat lame, I know. 

=cut

$ALTERNATIVE_HTML_TEMPLATE_PATH ||= undef; 


=pod

=head2 $TMP

Specifies the different directory that Dada Mail should use for 
writing temporary files. These files may contain sensitive data, like 
a copy of an outgoing message, so keep that in mind. 

=cut

$TMP ||= $FILES;
 

=pod

=head2 $ARCHIVES

Set B<$ARCHIVES> to the absolute path a directory that you want 
archives to be saved under.

=cut

$ARCHIVES  ||= $FILES; 


=pod

=head2 $BACKUPS

Set $BACKUPS to an absolute path to a directory to where you want 
list backups to be saved. 

=cut

$BACKUPS   ||= $FILES; 


=pod

=head2 %BACKUP_HISTORY 

%BACKUP_HISTORY sets how many different revisions of various list 
files are saved. 

=cut

%BACKUP_HISTORY = ( 

	settings  => 3,
	archives  => 3, 
	schedules => 3, 
) unless keys %BACKUP_HISTORY;


=pod

=head1 Program Behavior


=head2 FCKEditor Integration - $FCKEDITOR_URL

Currently, Dada Mail can use an inline HTML WYSIWYG Editor called FCKEditor for 
authoring of the HTML version of the mailing list message. To do this, 
you need to install FCKEditor. 

How to install FCKeditor: 

Download FCKeditor at: 

http://www.fckeditor.net/download/default.html

Uncompress the distribution you receive. It should make a directory called, "FCKeditor"

You'll want to put this entire directory into your public html directory of your hosting accout. Take note of the URL you'll need to access this directory. 

Set the B<$FCKEDITOR_URL> Config.pm variable to this URL. 

Done!

To tweak the configuration of how FCKeditor works within Dada Mail (advanced stuff), see the: 

/dada/DADA/Template/templates/FCKeditor_default_js_options.tmpl

file. 

=cut

$FCKEDITOR_URL ||= undef; 
						 # example: http://example.com/FCKeditor
                         #
                         # Remember to put single quotes around the URL
                         # and a semicolon at the end: 
                         # $FCKEDITOR_URL ||= 'http://example.com/FCKeditor'; 

=pod

=head2 $SCREEN_CACHE - Caching HTML Screens

Setting B<SCREEN_CACHE> to, 1 will save rendered HTML screens for 
future use, instead of having the program recreate them each and 
every time a certain screen is needed. 

If you have dynamic information in list templates, you may not 
want to use this option. 

More information: 

http://mojo.skazat.com/support/documentation/faq.pod.html#is_there_a_way_to_speed_up_screen_rendering__how_to_use_the_screen_cache_

=cut



$SCREEN_CACHE ||= 0; 


=pod

=head2 $GLOBAL_BLACK_LIST

A global black list means that all lists being run under Dada Mail 
use the same black list. Change the value to, "1" to enable.

This feature is only available using the SQL Subscriber backend.

=cut

$GLOBAL_BLACK_LIST ||= 0; 


=pod

=head2 $GLOBAL_UNSUBSCRIBE

Global Unsubscribe means that when a person unsubscribes from one list, they're 
unsusbcribed from every list under Dada Mail. Change the value to, "1" to enable.

This feature is only available using the SQL Subscriber backend.

It's advised that you take advantage of this feature if you also use the Global 
List Sending feature. 

=cut

$GLOBAL_UNSUBSCRIBE ||= 0; 


=pod

=head2 $GLOBAL_LIST_SENDING

When enabled, Global List Sending will allow you to send one copy of your message 
to more than one list. If a subscriber is present on more than one list, they will only 
receive one copy of the message. Change the value to, "1" to enable.

This feature is only available using the SQL Subscriber backend.

It's advised that you use this feature with the Global Unsubscribe feature, 
since although messages will be sent to all subscribers, the list that they will 
be sent from will be somewhat random. 

=cut

$GLOBAL_LIST_SENDING ||= 0; 


=pod 

=head2 @PING_URLS

@PING_URLS holds the URLS that should be sent an XML-RPC message 
when you add a new message to your archive.

Here's more information: 

http://www.xmlrpc.com/weblogsCom

You'll need the XMLRPC::Lite Perl module installed: 

http://search.cpan.org/~rjray/RPC-XML-0.57/

=cut

@PING_URLS = qw(

	http://rpc.pingomatic.com/
	http://rpc.weblogs.com/RPC2
	http://ping.blo.gs/
	http://rpc.technorati.com/rpc/ping

)	unless scalar @PING_URLS;


=pod

=head2 $DEFAULT_SCREEN

If no parameters are passed to the mail.cgi script, you will see the
default or main Dada Mail page. You can override that by setting any 
URL you want into $DEFAULT_SCREEN.

=cut

$DEFAULT_SCREEN ||= '';

=pod

If you do override this screen, it is recommended that you provide 
some way to at least unsubscribe to every one of your lists.

=cut


=pod

=head2 $DEFAULT_ADMIN_SCREEN

By default, when you log into the administration area you are shown
the "Send a List Message" screen. You can specify a different URL to 
go to by changing the $DEFAULT_ADMIN_SCREEN variable.

=cut



$DEFAULT_ADMIN_SCREEN ||= $S_PROGRAM_URL.'?flavor=send_email';

=pod

=head2 $DEFAULT_LOGOUT_SCREEN

When a user clicks the, "Logout" link on left hand menu of the control panel, they'll 
be redirected to the URL located in the, B<$DEFAULT_LOGOUT_SCREEN> variable. By default, 
this is set to the, B<$PROGRAM_URL> variable. 

=cut

$DEFAULT_LOGOUT_SCREEN ||= $S_PROGRAM_URL.'?flavor=admin';



my $PLUGIN_URL            = $S_PROGRAM_URL; 
   $PLUGIN_URL            =~ s/mail\.cgi$//;
   $PLUGIN_URL           .= 'plugins';
my $EXT_URL = $PLUGIN_URL; 
   $EXT_URL =~ s/plugins/extensions/; 
   

=pod 

=head2 $ADMIN_MENU

This generates the admin menu's various links and features, which can
then be turned on and off via the control panel. You shouldn't fool
around with $ADMIN_MENU itself unless you want to add a feature, like 
a plugin.

=cut

$ADMIN_MENU ||= [
	
	{-Title      => 'Send a List Message',
	 -Title_URL  => "$S_PROGRAM_URL?flavor=send_email",
	 -Function   => 'send_email',
	 -Activated  => 1,
	 -Submenu    => [
					{-Title      => 'Send a Webpage',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=send_url_email",
					 -Function   => 'send_url_email',
					 -Activated  => 1,
					},
					
					{-Title      => 'Send a List Invitation',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=list_invite",
					 -Function   => 'list_invite',
					 -Activated  => 1,
					},
					
					{-Title      => 'Monitor Your Mailings',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=sending_monitor",
					 -Function   => 'sending_monitor',
					 -Activated  => 1,
					},

			]
	},
	
	{-Title      => 'Manage List',
	 -Activated  => 1,
	 -Submenu    => [
					{-Title      => 'Change List Information',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=change_info",
					 -Function   => 'change_info',
					 -Activated  => 1,
					},
					
					{-Title      => 'Change Your List Password',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=change_password",
					 -Function   => 'change_password',
					 -Activated  => 1,
					},
					
					{-Title      => 'Mailing List Options',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=list_options",
					 -Function   => 'list_options',
					 -Activated  => 1,
					},
					
					{-Title      => 'Sending Options',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=sending_options",
					 -Function   => 'sending_options',
					 -Activated  => 1,
					},
					
					{-Title      => 'Delete This List',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=delete_list",
					 -Function   => 'delete_list',
					 -Activated  => 0,
					},
			]
	},
	
	{-Title      => 'Manage Subscribers',
	 -Activated  => 1,
	 -Submenu    => [
					{-Title      => 'View',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=view_list",
					 -Function   => 'view_list',
					 -Activated  => 1,
					},
					
					{-Title      => 'Add',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=add",
					 -Function   => 'add',
					 -Activated  => 1,
					},
					
					{-Title      => 'Remove',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=delete_email",
					 -Function   => 'delete_email',
					 -Activated  => 1,
					},
					
					#{-Title      => 'Search', 
					# -Title_URL  =>  "$S_PROGRAM_URL?flavor=search_email",
					# -Function   => 'search_email',
					# -Activated  => 1,
					#},
					
					{-Title      => 'Statistics', 
					 -Title_URL  =>  "$S_PROGRAM_URL?flavor=list_stats",
					 -Function   => 'list_stats',
					 -Activated  => 1,
					},
					
					{-Title      => 'Options', 
					 -Title_URL  =>  "$S_PROGRAM_URL?flavor=subscription_options",
					 -Function   => 'subscription_options',
					 -Activated  => 0,
					},
			]
	},
	
	{-Title     => 'Manage List Archive',
	 -Activated => 1,
	 -Submenu   => [
					{-Title      => 'View Archive',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=view_archive",
					 -Function   => 'view_archive',
					 -Activated  => 1,
					},
					
					{-Title      => 'Archive Options',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=archive_options",
					 -Function   => 'archive_options',
					 -Activated  => 1,
					},
			]
	},
	
	{-Title      => 'Manage Copy',
	 -Activated  => 1,
	 -Submenu    => [
					{-Title      => 'Email Messages',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=edit_type",
					 -Function   => 'edit_type',
					 -Activated  => 1,
					},
					
					{-Title      => 'HTML Messages',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=edit_html_type",
					 -Function   => 'edit_html_type',
					 -Activated  => 1,
					},
					
					{-Title      => 'Create a Back Link',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=back_link",
					 -Function   => 'back_link',
					 -Activated  => 1,
					},
			]
	},
	
	{-Title      => 'Manage Appearance',
	 -Activated  => 1,
	 -Submenu    => [
					{-Title      => 'Edit Template',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=edit_template",
					 -Function   => 'edit_template',
					 -Activated  => 1,
					},
					
					{-Title      => 'Subscription Form HTML',
					 -Title_URL  => "$S_PROGRAM_URL?flavor=html_code",
					 -Function   => 'html_code',
					 -Activated  => 1,
					},
			]
	},
	
#	{-Title      => 'Test Suite',
#	 -Activated  => 0,
#	 -Submenu    => [
#					{-Title      => 'Layout Test',
#					 -Title_URL  => "$S_PROGRAM_URL?flavor=test_layout",
#					 -Function   => 'test_layout',
#					 -Activated  => 0,
#					},
#					
#					{-Title      => 'Mail Formatting Test',
#					 -Title_URL  => "$S_PROGRAM_URL?flavor=send_email_testsuite",
#					 -Function   => 'send_email_testsuite',
#					 -Activated  => 0,
#					},
#			]
#	},

	
	{-Title      => 'About Dada Mail',
	 -Title_URL  => "$S_PROGRAM_URL?flavor=manage_script",
	 -Function   => 'manage_script',
	 -Activated  => 1,
	},
	
	{-Title      => 'Logout',
	 -Title_URL  => "$S_PROGRAM_URL?flavor=logout",
	 -Function   => 'logout',
	 -Activated  => 1,
	},
	
	{-Title      => 'Log Into Another List',
	 -Title_URL  => "$S_PROGRAM_URL?flavor=log_into_another_list",
	 -Function   => 'log_into_another_list',
	 -Activated  => 1,
	},
	
	{-Title      => 'Customize Feature Set',
	 -Title_URL  => "$S_PROGRAM_URL?flavor=feature_set",
	 -Function   => 'feature_set',
	 -Activated  => 0,
	},
	
	{-Title      => 'Plugins',
	 -Activated  => 1,
	 -Submenu    => [

#					# These are plugins. Make sure you install them 
#					# if you want to use them! 


#					{-Title      => 'Multi List Sub/Unsub Check',
#					 -Title_URL  => $PLUGIN_URL."/multi_admin_subscribers.cgi",
#					 -Function   => 'multi_admin_subscribers',
#					 -Activated  => 1,
#					},
#

#					{-Title      => 'Boilerplate Example',
#					 -Title_URL  => $PLUGIN_URL."/boilerplate_plugin.cgi",
#					 -Function   => 'boilerplate',
#					 -Activated  => 1,
#					},

#					{-Title      => 'Change the Program Root Password',
#					 -Title_URL  => $PLUGIN_URL."/change_root_password.cgi",
#					 -Function   => 'change_root_password',
#					 -Activated  => 0,
#					},

#					{-Title      => 'Discussion Lists',
#					 -Title_URL  => $PLUGIN_URL."/dada_bridge.pl",
#					 -Function   => 'dada_bridge',
#					 -Activated  => 1,
#					},

#					{-Title      => 'Clickthrough Tracking',
#					 -Title_URL  => $PLUGIN_URL."/clickthrough_tracking.cgi",
#					 -Function   => 'clickthrough_tracking',
#					 -Activated  => 1,
#					},

#					{-Title      => 'Scheduled Mailings',
#					 -Title_URL  => $PLUGIN_URL."/scheduled_mailings.pl",
#					 -Function   => 'scheduled_mailings',
#					 -Activated  => 1,
#					},

#					{-Title      => 'MX Lookup Verification',
#					 -Title_URL  => $PLUGIN_URL."/mx_lookup.cgi",
#					 -Function   => 'mx_lookup',
#					 -Activated  => 1,
#					},

#					{-Title      => 'View List Settings',
#					 -Title_URL  => $PLUGIN_URL."/view_list_settings.cgi",
#					 -Function   => 'view_list_settings',
#					 -Activated  => 1,
#					},

#					{-Title      => 'View Logs',
#					 -Title_URL  => $PLUGIN_URL."/log_viewer.cgi",
#					 -Function   => 'log_viewer',
#					 -Activated  => 1,
#					},

#					{-Title      => 'Email All List Owners',
#					 -Title_URL  => $PLUGIN_URL."/email_list_owners.cgi",
#					 -Function   => 'email_list_owners',
#					 -Activated  => 1,
#					},

#					{-Title      => 'Bounce Handler',
#					 -Title_URL  => $PLUGIN_URL."/dada_bounce_handler.pl",
#					 -Function   => 'dada_bounce_handler',
#					 -Activated  => 1,
#					},

				],
			},



#					# Shortcut to the Extensions. Make sure you install them 
#					# if you want to use them! 
#
#	{-Title      => 'Extensions',
#	 -Activated  => 1,
#	 -Submenu    => [
#
#					{-Title      => 'Multiple Subscribe',
#					 -Title_URL  => $EXT_URL."/multiple_subscribe.cgi",
#					 -Function   => 'multiple_subscribe',
#					 -Activated  => 1,
#					},
#
#
#					{-Title      => 'Update Subscriptions',
#					 -Title_URL  => $EXT_URL."/update_subscription.cgi",
#					 -Function   => 'update_subscription',
#					 -Activated  => 1,
#					},
#
#					{-Title      => 'Ajax\'d Subscription Form',
#					 -Title_URL  => $EXT_URL."/ajax_include_subscribe.cgi",
#					 -Function   => 'ajax_include_subscribe',
#					 -Activated  => 1,
#					},
#
#					{-Title      => 'Sending Monitor Outside Extension',
#					 -Title_URL  => $EXT_URL."/auto_pickup.pl",
#					 -Function   => 'auto_pickup',
#					 -Activated  => 1,
#					},
#
#							],
#			},



];


=pod

=head2 $LIST_QUOTA

$LIST_QUOTA, when set to anything other than B<undef>, can be used 
to set the maximum number of lists a Dada Mail install can have at 
one time. 


If set in an outside config file, you may also use the value, B<' '> 
to mean, "no quota"

=cut

$LIST_QUOTA ||= undef; 



=pod

=head2 $SUBSCRIPTION_QUOTA

$SUBSCRIPTION_QUOTA, when set to anything other than B<undef>, can be used 
to set the maximum number of subscribers in a Dada Mail list. 

B<This> variable will basically also set the limit of the 
per-list setting, B<subscription_quota>. Any limit set in this setting 
that's over the limit imposed in the, B<$SUBSCRIPTION_QUOTA> will be ignored. 

If set in an outside config file, you may also use the value, B<' '> 
to mean, "no quota"


=cut

$SUBSCRIPTION_QUOTA ||= undef; 



=pod

=head2 $SHOW_EMAIL_LIST

Customize the "View List" Screen in the Administration Area:
You can turn off and on many of the features in the "View List" 
administration area. If lists get really large, it may take some 
time for this page to load...and some people have reported that the 
screen won't load at all. The main reason for this is the scroll 
box that holds a list of all the subscribed people. Not only does 
it take time to sort through the list in alphabetical order and 
then print all the addresses out, it's also a huge burden for the 
browser to render a select box that large. It's not much help 
anyways to have a select box holding 10,000 email addresses. You 
can stop this select box from being shown by editing the below 
variable to '0'.

=cut

$SHOW_EMAIL_LIST ||= 1;

=pod

To turn it on again, change this variable to '1'.

=cut


=pod

=head2 $EMAIL_CASE

$EMAIL_CASE configures dada to either lowercase ONLY the 'domain' 
part of an email, or lowercase the entire email address. Lowercasing 
the domain is the correct way, since the 'name' part of an email 
should be case sensitive, but it is almost never handled that way.
Set this to 'lc_domain' to lowercase JUST the domain, or 
set this to 'lc_all' to lowercase the entire email address.

=cut

$EMAIL_CASE ||= 'lc_all'; 


=pod

=head2 @EMAIL_EXCEPTIONS

@EMAIL_EXCEPTIONS allows you to enter email addresses that wouldn't 
normally pass the email address validator. Good for testing offline 
when all you have is, say, root@localhost working.

=cut

@EMAIL_EXCEPTIONS = qw() 
	unless scalar @EMAIL_EXCEPTIONS;
	
	
=pod

=head2 $LIST_IN_ORDER

$LIST_IN_ORDER controls whether your email list is handled in
alphabetical order. Having a list in alphabetical order makes a list 
easier to work with but BE WARNED that this will, especially when 
you're using a plain text list, slow things down. If you have small 
lists then this shouldn't be too much of a problem. Set this variable 
to '1' to have your list sorted, '0', to keep your list unsorted.

=cut

$LIST_IN_ORDER ||= 0; 


=pod

=head2 $SHOW_DOMAIN_TABLE

This variable tells Dada Mail if you should show the 
"Top-Level Domains" table. You might not be interested in this 
information, or maybe your list is so large that your "View List" 
page is having trouble loading. Change this to '0' to stop the table 
from being shown.

=cut

$SHOW_DOMAIN_TABLE ||= 1; 


=pod

=head2 @DOMAINS

The Domain Table can also be customized.
You can put in or take away any top-level domain ending (like com 
or edu) by changing this list. Just add to the list, or delete 
something out of it - follow the pattern. Lots of top-level domain 
listings won't necessarily slow down the "View List" page. 

=cut

@DOMAINS = qw(
biz
com
info
net
org
edu
gov
mil
nu
us
) unless scalar @DOMAINS;


=pod 

=head2 $SHOW_SERVICES_TABLE 

This variable tells Dada Mail if it should show the "Services" table. 
Change it to '0' if you're not interested in this information, or if 
your list is so large that your "View List" page is having trouble 
loading. 

=cut

$SHOW_SERVICES_TABLE ||= 1; 


=pod

=head2 %SERVICES

The services Panel can also be customized.
You can put in or take away any service that you want to track by 
adding a record in between the parentheses. Here's an example of what 
a new service would look like: 
            
	'Altavista'     => 'altavista.net',

Put the NAME of the service on the left, and the domain ending 
that corresponds to that service on the right. The domain 
ending for America Online is "aol.com" - follow the pattern!

=cut

%SERVICES = ( 
'.Mac'          => 'mac.com',
'AOL'           => 'aol.com',
'Compuserve'    => 'compuserve.com', 
'Excite Mail'   => 'excite.com', 
'Gmail'         => 'gmail.com',
'Hotmail'       => 'hotmail.com',
'MSN'           => 'msn.com',
'PO Box'        => 'pobox.com', 
'Prodigy'       => 'prodigy.net',
'Yahoo!'        => 'yahoo.com',
) unless keys %SERVICES; 

# keep a list as a shorthand. 
@SERVICES = values %SERVICES; 


=pod

=head2 $FILE_CHMOD

$FILE_CHMOD is a variable that sets what permission Dada Mail sets 
files to when it initially writes them. You can set it to a few things: 

0660 - probably all you need
0666 - allows anyone to read and write files in the $FILES directory
0755 - probably insecure
0777 - shooting yourself in the foot insecure
0600 - godawful paranoid about the whole thing - life in general, 
       as secure as it gets

=cut

$FILE_CHMOD ||= 0666;

=pod

It's a good idea to figure out what works and leave this variable 
alone after your lists are set up, as you may not be able to access 
a list under a different $FILE_CHMOD.

We've changed what the $FILE_CHMOD Dada Mail is shipped (02/13/01) 
with from 0660 to 0666. Note that this may be less secure than 0660, 
but may solve some problems people are having. Change this back to 
0660 if everything seems to have been running just fine.

=cut


=pod

=head2 $DIR_CHMOD

Similar to $FILE_CHMOD, $DIR_CHMOD sets permissions to Directories 
created with Dada Mail. 
At the moment, this is limited to backup directories. 

=cut

$DIR_CHMOD ||= 0777; 


=pod

=head2 $HTML_CHARSET

=cut

$HTML_CHARSET ||= 'iso-8859-1'; 

# http://www.w3.org/International/O-charset.html
# http://www.w3.org/International/O-HTTP-charset

 
=pod 

=head1 List Control Panel


=head2 $SHOW_HELP_LINKS						

There are links on the bottom of some of the List Control Panel
screens that go to helpful tutorials on the Dada Mail support
site. If you'd like these messages taken off, set this variable
to '0'.

=cut

$SHOW_HELP_LINKS ||= 0;


=pod

=head2 $HELP_LINKS_URL

Provides an easy way to change the base URL of the Help Links. Not 
very useful, unless you want to have your own version of the Help 
Links. 

=cut

$HELP_LINKS_URL = 'http://mojo.skazat.com/support/manual/2.10.0';


=pod

=head1 Email Messages and Headers


=head2 @CHARSETS

Charsets that Dada Mail supports. These are the most used; to add 
your own would look like this: 

	'Description	charset',

There's a TAB between the Description and the actual charset: THIS 
IS REALLY IMPORTANT. 

=cut

@CHARSETS = ( 
'utf-8	utf-8', 
'Afrikaans (af)	 iso-8859-1',
'Afrikaans (af)	windows-1252',
'Albanian (sq)	 iso-8859-1',
'Albanian (sq)	 windows-1252',
'Arabic (ar)	iso-8859-6',
'Basque (eu)	iso-8859-1',
'Basque (eu)	windows-1252',
'Bulgarian (bg)	 iso-8859-5',
'Byelorussian (be)	 iso-8859-5',
'Catalan (ca)	iso-8859-1',
'Catalan (ca)	windows-1252',
'Croatian (hr)	 iso-8859-2',
'Czech (cs)	 iso-8859-2',
'Danish (da)	iso-8859-1',
'Danish (da)	windows-1252',
'Dutch (nl)	 iso-8859-1',
'Dutch (nl)	 windows-1252',
'English (en)	iso-8859-1',
'English (en)	windows-1252',
'Esperanto (eo)	 iso-8859-3',
'Estonian (et)	 iso-8859-15',
'Faroese (fo)	iso-8859-1',
'Faroese (fo)	windows-1252',
'Finnish (fi)	iso-8859-1',
'Finnish (fi)	windows-1252',
'French (fr)	iso-8859-1',
'French (fr)	windows-1252',
'Galician (gl)	 iso-8859-1',
'Galician (gl)	 windows-1252',
'German (de)	iso-8859-1',
'German (de)	windows-1252',
'Greek (el)	 iso-8859-7',
'Hebrew (iw)	iso-8859-8',
'Hungarian (hu)	 iso-8859-2',
'Icelandic (is)	 iso-8859-1',
'Icelandic (is)	 windows-1252',
'Inuit (Eskimo)	 iso-8859-10',
'Irish (ga)	 iso-8859-1',
'Irish (ga)	 windows-1252',
'Italian (it)	iso-8859-1',
'Italian (it)	windows-1252',
'Japanese (ja)	 shift_jis',
'Japanese (ja)	 iso-2022-jp',
'Japanese (ja)	 euc-jp',
'Lapp()	iso-8859-10',
'Latvian (lv)	iso-8859-13',
'Latvian (lv)	windows-1257',
'Lithuanian (lt)	iso-8859-13',
'Lithuanian (lt)	windows-1257',
'Macedonian (mk)	iso-8859-5',
'Maltese (mt)	iso-8859-3',
'Norwegian (no)	 iso-8859-1',
'Norwegian (no)	 windows-1252',
'Polish (pl)	iso-8859-2',
'Portuguese (pt)	iso-8859-1',
'Portuguese (pt)	windows-1252',
'Romanian (ro)	 iso-8859-2',
'Russian (ru)	koi8-r',
'Russian (ru)	iso-8859-5',
'Scottish (gd)	 iso-8859-1',
'Scottish (gd)	 windows-1252',
'Serbian (sr)	iso-8859-5',
'Slovak (sk)	iso-8859-2',
'Slovenian (sl)	 iso-8859-2',
'Spanish (es)	iso-8859-1',
'Spanish (es)	windows-1252',
'Swedish (sv)	iso-8859-1',
'Swedish (sv)	windows-1252',
 'Thai (th)	windows-874 ',
 'Turkish (tr)	iso-8859-9',
'Turkish (tr)	windows-1254',
'Ukrainian (uk)	 iso-8859-5'
) unless scalar @CHARSETS;


=pod

=head2 @PRECEDENCES

This is the default group of Precedences used when sending Bulk 
Messages. Be warned that the SMTP sending may not support any other
precedence value except the ones listed here. The Default is "undef", 
which will stop the Precedence header from being written out. 

=cut

@PRECEDENCES = (undef,'list','bulk','junk') unless scalar @PRECEDENCES; 


=pod

=head2 @Content_type

These are the default content-types. Add your own, have fun.

=cut

@CONTENT_TYPES = qw(
text/plain
text/html
) unless scalar @CONTENT_TYPES; 


=pod

=head2 %PRIORITIES

Priorities of mailings. I find people sending me things with the 
highest priority to tell me about credit cards really don't garner 
my attention. 

=cut

%PRIORITIES = ( 
'none' => 'Do not set a, "X-Priority" Header.', 
 5     => 'lowest',
 4     => 'low',
 3     => 'normal', 
 2     => 'high',
 1     => 'highest',
) unless keys %PRIORITIES;


=pod 


=head2 @CONTENT_TRANSFER_ENCODINGS

=cut                

@CONTENT_TRANSFER_ENCODINGS = qw(
7bit
8bit
quoted-printable
base64
binary
) unless scalar @CONTENT_TRANSFER_ENCODINGS;


=pod

=head1 $PROGRAM_CONFIG_FILE_DIR

This is how you can set all the variables located in the Config.pm 
module outside of the module itself. Why would you want to do that? 
It makes Dada Mail more upgradable: every time you upgrade Dada Mail 
you don't have to tweak this file (or tweak it only slightly); you 
just throw up the new distro and away you go! Now, Dada Mail finds 
this external config file in a bunch of ways. 

You can implicitly set the B<directory> it lives in by changing the 
B<$PROGRAM_CONFIG_FILE_DIR> variable that lives inside the Config.pm 
module. Wherever the external config file lives, it B<needs> to be 
called I<.dada_config> 

If you don't change the B<$PROGRAM_CONFIG_FILE_DIR> variable in the 
Config.pm file, Dada Mail will try to look in your home directory for 
the I<.dada_config> file. It tries to find your home directory in 
different places, one is the Environment Variable I<$ENV{'HOME'}> and 
by called the getpwuid() function as so: 

	getpwuid $> )[7]

The rub with these is that you usually can't get anything from the 
getpwuid() function unless you run the script as the same user that 
created it, ie via suEXEC or by setting the setuid bit. 

So, knowing this, the easiest, most suprise-unfriendly way to set the 
.dada_config file directory location is to *sigh* set it in this here 
Config.pm module. I'll leave setting the setuid bit for scripts that 
use the Config.pm file decision up to you. 

If you don't set any of the above, Config.pm will use the same 
directory that it's in as the directory to find the .dada_config file, 
which I guess ain't the worst way to go about things. 

Anyways, an example of a .dada_config file would look like this: 

 $PROGRAM_ROOT_PASSWORD  = 'root_password';
 $FILES                  = '/home/home_dir/dada_lists_dir';
 $MAILPROG               = '/usr/lib/sendmail';  
 $PROGRAM_URL            = 'http://yoursite.com/cgi-bin/dada/mail.cgi';

Pretty much any variable, array or hash can be saved in the 
.dada_config file, as long as it's not set inside a BEGIN{} block, 
which leaves out $PROGRAM_ERROR_LOG and @AnyDBM_File::ISA 
Treat .dada_config as a file that gets eval() right into Config.pm 
because, well, that's what happens. Because of this, great care should 
be made in where you put I<.dada_config>

The B<$PROGRAM_CONFIG_FILE_DIR> is located at the top of the Config.pm 
file, right after the first 4 variables for easy getting-at and 
fumbling.

If you need to set a variable in the outside config file to '0', it 
may not work. Instead, try setting it to '2'.

=cut


=pod

=head1 Formatting


=head2 Plain Text to HTML Encoding

Dada Mail uses the HTML::FromText CPAN module to convert plain text 
to HTML when showing plain text in archives and things like that. 
You can change the behavior of this formatting by changing what 
arguments get passed to the Text2HTML module, as described here: 

http://search.cpan.org/author/GDR/HTML-FromText-1.005/FromText.pm#SUMMARY_OF_OPTIONS

=cut

%HTMLFROMTEXT_OPTIONS = (
metachars => 1, 
urls      => 1, 
email     => 1,
paras     => 1, 
#bold      => 1, 
#underline => 1,
lines     => 1
) unless keys %HTMLFROMTEXT_OPTIONS; 



=pod

=head1 MIME Settings


=head2 %MIME_TYPES

These are the MIME types Dada Mail understands. The file ending is on 
the left, what MIME type it maps to is on the right. Feel free to add
your own. Dada Mail should be able to figure out the MIME type of a
file, but when it can't, it'll fall back on this.

=cut

%MIME_TYPES = ( 
'.gif'  => 'image/gif', 
'.jpg'  => 'image/jpg',
'.png'  => 'image/png',
'.jpeg' => 'image/jpeg',

'.pdf'  => 'application/pdf',
'.psd'  => 'application/psd',

'.html' => 'text/html',
'.txt'  => 'text/plain',

'.doc'  => 'application/msword',
'.xls'  => 'application/x-msexcel',
'.ppt'  => 'application/x-mspowerpoint',

'.mp3'  => 'application/octet-stream',
'.mov'  => 'video/quicktime',

) unless keys %MIME_TYPES;


=pod

=head2 $DEFAULT_MIME_TYPE

In case nothing up there matches what someone is trying to upload, 
there's a default MIME type for a last ditch guess. Some mail 
readers are sophisticated enough to figure out what an attachment is 
without its MIME type, but don't count on it. 

=cut

$DEFAULT_MIME_TYPE ||= 'application/octet-stream'; 


=pod

=head2 $MIME_PARANOID 

This is set for the $MIME::Lite::PARANOID variable. Set it to '1' 
if you don't know if you have the MIME::Base64 or MIME::QuotedPrint
or you don't know what those are. :) 

=cut

$MIME_PARANOID ||= 0;


=pod

=head2 $MIME_HUSH

Set mime_hush to '1' to suppress/unsuppress all warnings coming from 
this module.

=cut

$MIME_HUSH ||= 0;


=pod

=head2 $MIME_OPTIMIZE

Set to: 'faster', 'less memory', or 'no tmp files'. This controls how 
the MIME::Parser works. For more information: 

http://search.cpan.org/~dskoll/MIME-tools-5.417/lib/MIME/Parser.pm#OPTIMIZING_YOUR_PARSER

=cut

$MIME_OPTIMIZE ||= 'no tmp files'; 


=pod

=head1 Default Email Messages


=head2 $SUBSCRIBED_MESSAGE

This is the default "subscription successful!" email message. 
This message can be customized for each list in the list's Control Panel.

=cut

$SUBSCRIBED_MESSAGE  ||= <<EOF 

The subscription of the email address: 

	[email]
	
to the mailing list: 

	[list_name]

is complete. Thanks for subscribing! 

Please save this email message for future reference. 

-----------------------------------------------------------------------

Date of this subscription: [date]

You may automatically unsubscribe from this list at any time by 
visiting the following URL:

<[list_unsubscribe_link]>

If the above URL is inoperable, make sure that you have copied the 
entire address. Some mail readers will wrap a long URL and thus break
this automatic unsubscribe mechanism. 

You may also change your subscription by visiting this list's main screen: 

<[program_url]/list/[list]>

If you're still having trouble, please contact the list owner at: 

	<mailto:[list_owner_email]>

The following physical address is associated with this mailing list: 

[physical_address]

- <mailto:[list_owner_email]>

EOF
; 


=pod

=head2 $UNSUBSCRIBED_MESSAGE

This is the default "unsubscription successful!" email message. 
This message can be customized for each list in the list's Control Panel.

=cut

$UNSUBSCRIBED_MESSAGE  ||= <<EOF

The removal of the email address:

	[email]
	
from the mailing list: 

	[list_name] 

is complete.

You may wish to save this email message for future reference.

-----------------------------------------------------------------------

Date of this removal: [date]

You may automatically re-subscribe to this list at any time by 
visiting the following URL:

<[list_subscribe_link]>

If the above URL is inoperable, make sure that you have copied the 
entire address. Some mail readers will wrap a long URL and thus break
this automatic unsubscribe mechanism. 

You may also change your subscription by visiting this list's main screen: 

<[program_url]/list/[list]>

If you're still having trouble, please contact the list owner at: 

	<mailto:[list_owner_email]>

The following physical address is associated with this mailing list: 

[physical_address]

- <mailto:[list_owner_email]>

EOF
; 


=pod

=head2 $CONFIRMATION_MESSAGE

This is the default "subscription confirmation" email message. 
This message can be customized for each list in the list's Control Panel.

=cut

$CONFIRMATION_MESSAGE ||= <<EOF   

This message has been sent to you as the final step to confirm your
email list subscription for the following list: 

[list_name]

To confirm this subscription, please follow the URL below:

<[list_confirm_subscribe_link]>

(Click the URL above, or copy and paste the URL into your browser. 
Doing so will subscribe you to this list.)

-----------------------------------------------------------------------

The following is the description given for this list: 

[list_info]

-----------------------------------------------------------------------

This double opt-in confirmation email was sent to protect the privacy
of the owner of this email address. Double opt-in confirmation 
guarantees that only the owner of an email address can subscribe themselves
to this mailing list.

Furthermore, the following privacy policy is associated with this list: 

[privacy_policy]

Please read and understand this privacy policy. Other mechanisms may 
have been enacted to subscribe email addresses to this list, such as
physical guestbook registrations, verbal agreements, etc.

If you did not ask to be subscribed to this particular list, please
do not visit the confirmation URL above. The confirmation for 
subscription will not go through and no other action on your part 
will be needed.

To contact the owner of this email list, please use the address below: 

<mailto:[list_owner_email]>

The following physical address is associated with this mailing list: 

[physical_address]

- [list_owner_email]

EOF
; 


=pod

=head2 $UNSUB_CONFIRMATION_MESSAGE

This is the default "subscription confirmation" email message. 
This message can be customized for each list in the list's Control Panel.

=cut

$UNSUB_CONFIRMATION_MESSAGE ||= <<EOF   

This message has been sent to you as the final step to confirm your
email *removal* for the following list: 

[list_name]

To confirm this unsubscription, please follow the URL below:

<[list_confirm_unsubscribe_link]>

(Click the URL above, or copy and paste the URL into your browser. 
Doing so will remove you to this list.)

-----------------------------------------------------------------------

The following is the description given for this list: 

[list_info]

-----------------------------------------------------------------------

This double opt-out confirmation email was sent to protect the privacy
of the owner of this email address. 

Furthermore, the following privacy policy is associated with this list: 

[privacy_policy]

Please read and understand this privacy policy. 

If you did not ask to be removed from this particular list, please
do not visit the confirmation URL above. The confirmation for removal 
will not go through and no other action on your part will be needed.

To contact the owner of this email list, please use the address below: 

<mailto:[list_owner_email]>

The following physical address is associated with this mailing list: 

[physical_address]


- <mailto:[list_owner_email]>

EOF
; 


=pod

=head2 $MAILlING_LIST_MESSAGE

This is the default "Mailing List!" email message. 
This message can be customized for each list in the list's Control Panel.

=cut

$MAILlING_LIST_MESSAGE ||= <<EOF  
(Mailing list information, including unsubscription instructions, 
is located at the end of this message.)
__ 

[message_body]

-- 
The following information is a reminder of your current mailing
list subscription: 

You are subscribed to the following list: 
	[list_name]
	
using the following email:
	[email]

You may automatically unsubscribe from this list at any time by 
visiting the following URL:

<[list_unsubscribe_link]>

If the above URL is inoperable, make sure that you have copied the 
entire address. Some mail readers will wrap a long URL and thus break
this automatic unsubscribe mechanism. 

You may also change your subscription by visiting this list's main screen: 

<[program_url]/list/[list]>

If you're still having trouble, please contact the list owner at: 

	<mailto:[list_owner_email]>

The following physical address is associated with this mailing list: 

[physical_address]

EOF
; 


=pod

=head2 $MAILlING_LIST_MESSAGE_HTML

Similar to $MAILlING_LIST_MESSAGE, but used specifically for HTML messages. 

=cut

$MAILlING_LIST_MESSAGE_HTML ||= <<EOF
<!--opening-->
<p><em>(Mailing list information, including unsubscription instructions, 
is located at the end of this message.)</em><br/></p>
<!--/opening-->

[message_body]

<!--signature-->
<p>The following information is a reminder of your current mailing
list subscription: </p>

<p>You are subscribed to the following list: </p>

<p><strong>[list_name]</strong></p>
	
<p>using the following email:</p>

<p><strong>[email]</strong></p>

<p>You may automatically unsubscribe from this list at any time by 
visiting the following URL:</p>

<p>
 <a href="[plain_list_unsubscribe_link]">
  [plain_list_unsubscribe_link]
 </a>
</p>

<p>If the above URL is inoperable, make sure that you have copied the 
entire address. Some mail readers will wrap a long URL and thus break
this automatic unsubscribe mechanism.</p> 

<p>You may also change your subscription by visiting this list's main 
screen:</p>

<p>
 <a href="[program_url]/list/[list]">
  [program_url]/list/[list]
 </a>
</p>

<p>If you're still having trouble, please contact the list owner at:</p> 

	<p>
	 <a href="mailto:[list_owner_email]">
	 [list_owner_email]
	 </a>
	</p>

<p>The following physical address is associated with this mailing list:</p> 

 [physical_address]

<!--/signature-->
EOF
; 


=pod

=head2 $NOT_ALLOWED_TO_POST_MESSAGE

This message is sent to someone who is not allowed to post to your 
list using the dada_bridge.pl script. If you do not use the 
dada_bridge.pl script, this won't be of any use to you! This message 
can be customized for each list in the list's Control Panel.

=cut

$NOT_ALLOWED_TO_POST_MESSAGE ||= <<EOF  

[program_name] Error - 

Sorry, it doesn't seem that you are allowed to post on: 

	[list_name]
	
with the email address: 

    [email]

This may be because you have to first subscribe to the list to post to the 
list itself. 

Please see: 

	<[program_url]/list/[list]>

for more information, or email the list owner at: 

	<mailto:[list_owner_email]>

EOF
; 


$YOU_ARE_ALREADY_SUBSCRIBED_MESSAGE ||= <<EOF

Hello, 

This message has been sent to you because a request to subscribe: 

[email]

to the list: 

[list_name]

was just made. This email address is actually already subscribed, 
so you do not have to subscribe again. This message has been sent 
to protect your privacy and only allow this information to be 
available to you. 

If you would like to change your subscription, please visit this address: 

[program_url]/list/[list]/

If the above URL is inoperable, make sure that you have copied the 
entire address. Some mail readers will wrap a long URL and thus break
this automatic unsubscribe mechanism. 

To contact the owner of this email list, please use the address below: 

<mailto:[list_owner_email]>


- [list_owner_email]

EOF
; 




=pod

=head1 Default HTML Screens


=head2 $HTML_CONFIRMATION_MESSAGE

Shown when a request to subscribe is successful.

=cut

$HTML_CONFIRMATION_MESSAGE ||= <<EOF

<h1>Please confirm your mailing list subscription</h1>  

<p>An email message has been sent to the following address:</p>

<blockquote>
 <p>
  <strong>
  [subscriber_email] 
  </strong>
 </p>
</blockquote>
 
<p>to confirm the subscription to the following list: </p>

<blockquote>
 <p>
  <strong>
  [list_name]
  </strong>
 </p>
</blockquote>

<p>Upon receiving this message, you will need to follow a confirmation 
URL, located in the message itself.</p>

<p>This confirmation process, known as double opt-in confirmation, has 
been put into place to protect the privacy of the owner of this email 
address.</p>

<p>If you do not receive this confirmation, make sure that this email 
address: </p>

 <blockquote>
 <p>
  <strong>
   <a href=mailto:[list_owner_email]>[list_owner_email]</a>
  </strong>
 </p>
</blockquote>


<p>is in your 
 <strong> 
  address book
 </strong> 
 or 
 <strong> 
  whitelist
 </strong>
 .
</p>

<p>
 <strong> 
  <a href="[program_url]/subscriber_help/[list]/">
   How to add [list_owner_email] to your address book/white list
  </a>
 </strong> 
</p>

<p>If you still do not receive a confirmation for subscription in 
the next twenty-four hours or you have any other questions regarding 
this mailing list, please contact the list owner at: </p>

<p style="text-align:center">
 <a href=mailto:[list_owner_email]>[list_owner_email]</a>
</p>

EOF
; 


=pod

=head2 $HTML_UNSUB_CONFIRMATION_MESSAGE

Shown when a request to unsubscribe is successful.

=cut

$HTML_UNSUB_CONFIRMATION_MESSAGE ||= <<EOF

<h1>Please confirm your mailing list unsubscription</h1>  

<p>An email message has been sent to the following address:</p>

<blockquote>
 <p>
  <strong>
  [subscriber_email] 
  </strong>
 </p>
</blockquote>
 
<p>to confirm that address's <em>removal</em> from the following list: </p>

<blockquote>
 <p>
  <strong>
  [list_name]
  </strong>
 </p>
</blockquote>

<p>Upon receiving this message, you will need to follow a confirmation 
URL, located in the message itself.</p>

<p>This confirmation process, known as double opt-out confirmation, 
has been put into place to protect the privacy of the owner of this 
email address.</p>

<p>If you do not receive a confirmation for <em>removal</em> in the 
next twenty-four hours or you have any other questions regarding this 
mailing list, please contact the list owner at: </p>

<p style="text-align:center">
 <a href=mailto:[list_owner_email]>[list_owner_email]</a>
</p>

EOF
; 
 

=pod

=head2 $HTML_SUBSCRIBED_MESSAGE

Shown when a subscription is successful.

=cut

$HTML_SUBSCRIBED_MESSAGE ||= <<EOF 

<h1>Subscription is successful!</h1>

<p>You are now subscribed to the following mailing list:</p>

<blockquote>
 <p>
  <strong>
   [list_name]
  </strong>
 </p>
</blockquote>

<p>using the following email address:</p>

<blockquote>  
 <p>
  <strong>
  [subscriber_email]
  </strong>
 </p>
</blockquote> 

<p>An email will be sent to your address giving you more details of 
this subscription, including how to unsubscribe in the future.</p>

EOF
; 


=pod

=head2 $HTML_UNSUBSCRIBED_MESSAGE

Shown when an unsubscription is successful.

=cut

$HTML_UNSUBSCRIBED_MESSAGE ||= <<EOF  

<h1>You have been unsubscribed from the list: [list_name]</h1>

<p>The email address: [subscriber_email] is no longer a part of 
[list_name]. Thanks for subscribing.</p> 

EOF
;


=pod

=head2 $TEXT_INVITE_MESSAGE

The text version of the list invitation message.

=cut

$TEXT_INVITE_MESSAGE ||= <<EOF  

Hello! 

I wanted to tell you about my email list, [list_name]: 

[list_info] 

I thought you might be interested in subscribing to it. If you 
want to, just click this link: 

[plain_list_confirm_subscribe_link] 

This is a one-time mailing. You won't hear from us again unless you 
subscribe. 

- [list_owner_email]

EOF
;


=pod

=head2 $HTML_INVITE_MESSAGE

The HTML version of the list invitation message.

=cut

$HTML_INVITE_MESSAGE ||= <<EOF  

<p><strong>Hello!</strong></p> 

<p>I wanted to tell you about my email list, [list_name]:</p> 

<blockquote> 
 <p>[list_info]</p>
</blockquote> 

<p>I thought you might be interested in subscribing to it. If you 
want to, just click 
<strong><a href="[plain_list_confirm_subscribe_link]">here</a></strong>.</p> 
 

<p>This is a one-time mailing. You won't hear from us again unless 
you subscribe.</p> 

<p>- <a href='mailto:[list_owner_email]'>[list_owner_email]</a></p>

EOF
;


=pod

=head2 $SEND_ARCHIVED_MESSAGE

The text version of the message sent when an archived message is sent 
to a friend.

=cut

$SEND_ARCHIVED_MESSAGE ||= <<EOF

Hello, 

On behalf of: [sender_email], the following archived message from: 

[list_name] 

has been sent to you. They wrote: 

[note]

The archived message is below. 

You can subscribe to [list_name] by following this link:

[list_subscribe_link]

If you cannot view the archived message, please visit: 

[archive_message_url]

EOF
;


=pod

=head2 $HTML_SEND_ARCHIVED_MESSAGE

The HTML version of the message sent when an archived message is sent 
to a friend.

=cut

$HTML_SEND_ARCHIVED_MESSAGE ||= <<EOF

<p>Hello,</p> 

<p>On behalf of: [sender_email], the following archived message 
from:</p>

<p>[list_name]</p>

<p>has been sent to you. They wrote:</p> 

<p>
 <em> 
  [note]
 </em> 
</p>

<p>The archived message is below.</p> 

<p>You can subscribe to [list_name] by following this link:</p>

<p><a href="[plain_list_subscribe_link]">[plain_list_subscribe_link]</a>.</p>

<p>If you cannot view the archived message, please visit:</p>

<p><a href="[archive_message_url]">[archive_message_url]</a></p>

EOF
;




# Good Job! 
$GOOD_JOB_MESSAGE ||= '<p class="positive">Your changes have been saved successfully!</p>'; 

# No one's subscribed? 
$NO_ONE_SUBSCRIBED ||= '<p class="error">No one is subscribed to your list at the moment.</p>'; 

######################################################################



=pod

=head1 List Setting Defaults


=head2 %LIST_SETUP_DEFAULTS

These defaults will be used when CREATING a new list. These defaults 
will also be used for existing lists if there isn't a variable 
already set. These values correspond to the values created in the 
list databases. An example would be: 

	%LIST_SETUP_DEFAULTS = ( 
	                         black_list    => 1, 
	                         send_via_smtp => 1,
	                        );

This would setup all lists created now with blacklists on, and mail
being sent using SMTP. 

Note! You *can* enter the passwords for both POP3 
(for POP-before-SMTP stuff) and the SMTP SASL password here, but they will be 
in plain text. When these passwords are saved in the list settings, they are 
encrypted. 

=cut

%LIST_SETUP_DEFAULTS = (
	
	list                               => '', # don't default...
	info                               => '', 
	admin_email                        => '', 
	list_owner_email                   => '', 
	privacy_policy                     => '', 
	list_name                          => '', 
	physical_address                   => '',
	password                           => '', # you'll need to encrypt it to use this...

# Misc...

    cipher_key                         => undef, 
    admin_menu                         => undef, 
    
    
	#quotas
	use_subscription_quota             => 0, 
	    subscription_quota             => 0, 

	#mailing list options 	
	mx_check                           => 0,
	closed_list                        => 0, 
	show_hidden                        => 0,	
	hide_list                          => 0,
	
	email_your_subscribed_msg          => 0, 
	
	send_unsub_success_email           => 1,
	send_sub_success_email             => 1,
	
	get_sub_notice                     => 1, 
	get_unsub_notice                   => 1, 
	
	no_confirm_email                   => 1, # double opt-in
	unsub_confirm_email                => 1, # double opt-out 
	                                         # I know, confusing. 
	
	limit_sub_confirm                  => 0, 
	limit_unsub_confirm                => 0,  
	
	use_alt_url_sub_confirm_success      => 0,
	    alt_url_sub_confirm_success_w_qs => 0, 
		alt_url_sub_confirm_success      =>  '',
	
	use_alt_url_sub_confirm_failed      => 0,
	    alt_url_sub_confirm_failed_w_qs => 0, 
		alt_url_sub_confirm_failed      => '',
	
	use_alt_url_sub_success            => 0,
	    alt_url_sub_success_w_qs       => 0, 
		alt_url_sub_success            => '',
	
	use_alt_url_sub_failed             => 0,
		alt_url_sub_failed_w_qs        => 0, 
		alt_url_sub_failed             => '',
	
	use_alt_url_unsub_confirm_success      =>  0,
	    alt_url_unsub_confirm_success_w_qs => 0, 
		alt_url_unsub_confirm_success      => '',
	 
	use_alt_url_unsub_confirm_failed      => 0,
		alt_url_unsub_confirm_failed      => '',
	    alt_url_unsub_confirm_failed_w_qs => 0, 

	use_alt_url_unsub_success          => 0,
	    alt_url_unsub_success_w_qs     => 0, 
		alt_url_unsub_success          => '',
	
	use_alt_url_unsub_failed           => 0,
	    alt_url_unsub_failed_w_qs      => 0, 
		alt_url_unsub_failed           => '',
	
	captcha_sub                        => 0, 	

# SMTP Options

	smtp_server                  => undef,
	smtp_port                    => 25, 
	
    use_smtp_ssl                 => 0,     
	use_pop_before_smtp          => 1,

	pop3_server                  => undef, 
	pop3_username                => undef, 
	pop3_password                => undef, 
	
	set_smtp_sender              => 0,  
	
	use_sasl_smtp_auth           => 0, 
	sasl_auth_mechanism          => 'PLAIN', 
	sasl_smtp_username           => undef, 
	sasl_smtp_password           => undef, 
	
	smtp_max_messages_per_connection => undef, 
	
# Sending Options 
	
	# Enable Batch Sending
	enable_bulk_batching        => 1,
	
	# Receive Finishing Message 
	get_finished_notification   => 1,
	
	# Send: [x] message(s) per batch 
	bulk_send_amount            => 1, 

    # and then wait: [x] seconds, before the next
	bulk_sleep_amount           => 8, 
	
	# Auto-Pickup Dropped List Message Mailings 
    auto_pickup_dropped_mailings       => 1, 
    
    # Restart Mailings After Each Batch 
    restart_mailings_after_each_batch  => 0, 
    
    # Send Email Using SMTP 
    send_via_smtp                      => 0, 

# adv sending options

	precedence                   => undef, 
	charset                      => 'English (en)	iso-8859-1',
	priority                     => 3,
	print_list_headers           => 1,
	
	print_errors_to_header       => 0, 
	print_return_path_header     => 0,
	plaintext_encoding           => '8bit', 
	html_encoding                => '8bit',
	use_habeas_headers           => 0,
	strip_message_headers        => 0, 
	add_sendmail_f_flag          => 0, 
	verp_return_path             => 0, 
    use_domain_sending_tunings   => 0, 
    domain_sending_tunings       => {}, 

	
# view list prefs

	view_list_subscriber_number  => 100,
	
# archive prefs

	archive_messages             => 1,
	show_archives                => 1,
	archive_subscribe_form       => 1,
	archive_search_form          => 1,
	captcha_archive_send_form    => 0, 
	archive_send_form            => 0,
	send_newest_archive          => 0, 
	
	archive_show_second          => 0, 
	archive_show_hour_and_minute => 0, 
	archive_show_month           => 1,
	archive_show_day             => 1,
	archive_show_year            => 1,
	archive_index_count          => 10,
	
	
	sort_archives_in_reverse     => 1,
	disable_archive_js           => 1, 
	style_quoted_archive_text    => 1,
	stop_message_at_sig          => 1, 
	publish_archives_rss         => 1,
	ping_archives_rss            => 0,
	html_archives_in_iframe      => 0, 
	display_attachments          => 1,
	add_subscribe_form_to_feeds  => 1, 
	
	add_social_bookmarking_badges => 0, 
	
# archive editing prefs
	
	editable_headers             => 'Subject', 
 	
	#blacklist 
	black_list                           => 0,
	add_unsubs_to_black_list             => 0,
	allow_blacklisted_to_subscribe       => 0,
	allow_admin_to_subscribe_blacklisted => 0,


# White List Prefs

	# These aren't currently used...
	# white list 
	# enable_white_list            => 0,
		
# Edit Template Prefs

	get_template_data                => 'from_default_template',
	url_template                     => '',
	apply_list_template_to_html_msgs => 0, 
	
# Create a back link prefs
    
    website_name       => '', 
    website_url        => '', 
	
	
	
#SQL stuff
	
	# I don't think this is honored...
	subscription_table               => 'dada_subscribers',
	
 #mail merging stuff - I'd keep this pretty much as it is. 
 # (not currently known) 
 
	hard_remove                  => 1,
	merge_fields                 => '',
	

# Email Templates

	subscribed_message              =>   $SUBSCRIBED_MESSAGE, 
	unsubscribed_message            =>   $UNSUBSCRIBED_MESSAGE, 

	confirmation_message            =>   $CONFIRMATION_MESSAGE,
	unsub_confirmation_message      =>   $UNSUB_CONFIRMATION_MESSAGE,

	mailing_list_message            =>   $MAILlING_LIST_MESSAGE,
	mailing_list_message_html       =>   $MAILlING_LIST_MESSAGE_HTML,

	not_allowed_to_post_message     =>   $NOT_ALLOWED_TO_POST_MESSAGE, 


# HTML Screen Templates

	html_confirmation_message       =>   $HTML_CONFIRMATION_MESSAGE,
	html_unsub_confirmation_message =>   $HTML_UNSUB_CONFIRMATION_MESSAGE,

	html_subscribed_message         =>   $HTML_SUBSCRIBED_MESSAGE,
	html_unsubscribed_message       =>   $HTML_UNSUBSCRIBED_MESSAGE,

	send_archive_message            =>   $SEND_ARCHIVED_MESSAGE,
	send_archive_message_html       =>   $HTML_SEND_ARCHIVED_MESSAGE,

# Send a List Invitation
	invite_message_text             =>   $TEXT_INVITE_MESSAGE,
	invite_message_html             =>   $HTML_INVITE_MESSAGE,	
	invite_message_subject          =>   undef, 
	
	you_are_already_subscribed_message => $YOU_ARE_ALREADY_SUBSCRIBED_MESSAGE, 

# Feature Set

    disabled_screen_view                => 'hide', 
    

# Send me the list password.    
    pass_auth_id                        => undef, 
    


### Plugins 

# dada_bridge.pl

	group_list                   => 0, 
	allow_group_interpolation    => 0,
	only_allow_group_plain_text  => 0,
	add_reply_to                 => 1,
	mail_group_message_to_poster => 1,
	append_list_name_to_subject  => 1,
	
	no_append_list_name_to_subject_in_archives => 1, 
	
	set_to_header_to_list_address     => 0, 
	append_discussion_lists_with      => 'list_shortname',
	send_msgs_to_list                 => 1, 
	disable_discussion_sending        => 1, 
	mail_discussion_message_to_poster => 1, 
	
    ignore_spam_messages                => 0, 
    find_spam_assassin_score_by         => 'looking_for_embedded_headers',
    ignore_spam_messages_with_status_of => 6, 
    enable_moderation                   => 0, 
    send_moderation_rejection_msg       => 0, 
    send_msg_copy_address               => '', 
    
    strip_file_attachments              => 0, 
    file_attachments_to_strip           => '', 
    discussion_pop_server               => '', 
    discussion_pop_username             => '', 
    discussion_pop_email                => '', 
    discussion_pop_password             => '', 
    send_not_allowed_to_post_msg        => 0, 
    send_invalid_msgs_to_owner          => 0, 
    send_msg_copy_to                    => 0, 

# Clickthrough Tracking

	clickthrough_tracking           => 0,
	enable_open_msg_logging         => 0, 
	enable_subscriber_count_logging => 0, 
	enable_bounce_logging           => 0,

    
# dada_digest.pl 
last_digest_sent                   => undef, 
    
) unless keys %LIST_SETUP_DEFAULTS;

%LIST_SETUP_INCLUDE = () 
	unless keys %LIST_SETUP_INCLUDE;


=pod

=head2 %LIST_SETUP_INCLUDE

Similar to, %LIST_SETUP_DEFAULTS, %LIST_SETUP_INCLUDE holds defaults values for lists. 

The difference is that any value NOT set here, will be set, in 
accordance to what %LIST_SETUP_DEFAULTS already has. Because of this,
it's much more convenient to use this variable in the outside config 
file. 

For example, if you set up the bounce handler with the bounce 
email of, "bounce@example.com", 
you could set %LIST_SETUP_INCLUDE to have these values: 


 %LIST_SETUP_INCLUDE = (
 set_smtp_sender              => 1, # For SMTP   
 add_sendmail_f_flag          => 1, # For Sendmail Command
 admin_email                  => 'bounce@example.com',
 );

And all new lists would automatically be hooked up to the bounce handler. 

=cut

%LIST_SETUP_DEFAULTS = (%LIST_SETUP_DEFAULTS, %LIST_SETUP_INCLUDE); 

=pod

=head2 %LIST_SETUP_OVERRIDES

B<%LIST_SETUP_OVERRIDES> will override any setting that's in the 
B<%LIST_SETUP_DEFAULTS> hash and whatever is set in the list 
preferences. 

=cut

%LIST_SETUP_OVERRIDES = (

    # mail_bulkmail is going to be disabled...
	smtp_engine                  => 'net_smtp',



) unless keys %LIST_SETUP_OVERRIDES;


=pod

=head1 Additional Settings You'll Probably Not Need to Change 

(advanced hacker stuff)


=head2 Operating System

Dada Mail tries to guess your Operating System using the $^O variable. 
If it's guessing wrong, you can set it yourself. 

=cut

$OS ||= $^O;


=pod

=head2 $NULL_DEVICE

$NULL_DEVICE refers to where the /dev/null device or file or whatever 
you more smert people call that thing... is located. On most *nix's, 
it's at /dev/null. You may have to change it. For example, if you're 
a Windows folk. 

=cut

$NULL_DEVICE ||= '/dev/null'; 


=pod

=head2 Seed Random Number Generator

if this is taken off, the seed random number will be made from the 
time, or from something pretty random, depending on your version 
of Perl.

=cut

srand ( time() ^ ($$ + ($$ << 15)) );  


=pod

=head2 $FIRST_SUB, $SEC_SUB

Where is the salt number located in the encrypted password? It's 
usually at substr(0,2) but may be different on different systems, 
some systems are set to substring(3,2).
Actually, I've only had this problem on one system - mine :) - 
which was a FreeBsd 4.0 distro. Under most cases, this is NOT going 
to be your problem!

=cut

$FIRST_SUB ||= 0;
$SEC_SUB   ||= 2;


=pod

=head2 $SALT

The salt number. Change $SALT to
 
	 $SALT = "mj";

if all else fails. 

=cut

@C=('a'..'z', 'A'..'Z', '0'..'9','.','/');
$SALT=$C[rand(@C)].$C[rand(@C)];


=pod

=head2 $PIN_WORD $PIN_NUM 

A pin number is made when someone wants to subscribe to your list. 
They will get a confirmation email with a special link that includes 
their email, and a pin that's generated from the email and the 
variables below using a mathematical equation. It's much harder to 
guess a pin with these two variables changed:

=cut

# Pick a word. It really doesn't matter what the word is - a longer 
# word doesn't necessarily mean a better pin number. 

if(!defined($PIN_WORD)){ 
	$PIN_WORD = ($ROOT_PASS_IS_ENCRYPTED == 1) ? ($PROGRAM_ROOT_PASSWORD) : ('dada');
}	

# Pick a number. I would keep it between 1 and 9. 
$PIN_NUM  ||= unpack("%32C*", $FILES);


=pod

=head2 @AnyDBM_File

Change what DB Dada Mail will use. 
Dada Mail can use various db packages to save each list's information.
It looks for the best one and uses the next package in the list if it 
can't find it. If you get a software error (an error 500, not having 
any information changed when creating a new list) you may have to 
change this to: 

	BEGIN { @AnyDBM_File::ISA = qw(SDBM_File) }

SDBM is the worst package to use, but it is always available with perl.
See the man page for the AnyDBM_File for more information.

=cut

BEGIN { @AnyDBM_File::ISA = qw(DB_File GDBM_File) }

=pod

Check the AnyDBM_File for more info.

=cut


=pod

=head2 $ATTACHMENT_TEMPFILE

To add an attachment to a list message in Dada Mail from the control 
panel, we have to upload it via the web browser. There are two ways 
we can do this. One is to save the information in the $FILES 
directory and then open it up, attach it, and then delete it; and the 
other involves some magical qualities of CGI.pm and MIME::Lite, 
probably coupled with your server's /tmp file, if you can use it. 
Setting $ATTACHMENT_TEMPFILE to '1' uploads, saves, attaches and then 
deletes the file. Setting it to '0' does it magically. I suggest '1', 
unless you want to play around with it. 

=cut

$ATTACHMENT_TEMPFILE ||= 0;

=pod

=head2 $MAIL_VERP_SEPARATOR

See: http://search.cpan.org/~gyepi/Mail-Verp-0.05/Verp.pm

=cut

$MAIL_VERP_SEPARATOR = '-'; 

=pod

=head1 Variables That Don't Need Changin'


=head2  $VER

This is the version of this Dada Mail Program. 
Mostly it's used to see if there's a new version out there to use
and to say that you've got the freshest tools on the Web.

=cut

$VER ||= '2.10.16'; 

# If you're having problems with Dada Mail PLEASE tell me what the version 
# of it is. Each new version of Dada Mail is SOOOO different from each 
# other, if I put two different releases together, I'd have Dada Mail 4.0 
# by now.
#####################################################################


=pod

=head2 $PROGRAM_NAME

This is the name of the program. I guess if this script has a mid-life 
crisis or something, it can change its name, buy a really fast car 
and start chasing guys half her age. 

=cut

$PROGRAM_NAME ||= "For Chino Hills";


%EMAIL_HEADERS = (

 Date                       =>    undef, 
 From                       =>    undef,
 To                         =>    undef,
 Cc                         =>    undef, 
 Bcc                        =>    undef, 
'Return-Path'               =>    undef, 
'Reply-To'                  =>    undef, 
'In-Reply-To'               =>    undef, 
'Errors-To'                 =>    undef, 
References                  =>    undef,
 'X-Priority'               =>    undef,

'Content-Base'              =>    undef, 
 List                 	    =>    undef, 
'List-Archive'       	    =>    undef, 
'List-Digest'         	    =>    undef, 
'List-Help'          	    =>    undef, 
'List-ID'                   =>    undef, 
'List-Owner'                =>    undef, 
'List-Post'                 =>    undef, 
'List-Subscribe'            =>    undef, 
'List-Unsubscribe'          =>    undef, 
'List-URL'                  =>    undef,  
'X-BeenThere'               =>    undef, 

'X-Habeas-SWE-1'            =>    undef, 
'X-Habeas-SWE-2'            =>    undef, 
'X-Habeas-SWE-3'            =>    undef, 
'X-Habeas-SWE-4'            =>    undef, 
'X-Habeas-SWE-5'            =>    undef, 
'X-Habeas-SWE-6'            =>    undef, 
'X-Habeas-SWE-7'            =>    undef, 
'X-Habeas-SWE-8'            =>    undef, 
'X-Habeas-SWE-9'            =>    undef, 

'Message-ID'                =>    undef, 
 Precedence                 =>    undef,

'X-Mailer'                  =>   "$PROGRAM_NAME $VER ", 
'X-BounceHandler'           =>    undef, 
   
 Sender                     =>    undef, 
'Content-type'              =>    undef, 
'Content-Transfer-Encoding' =>    undef, 
# Content-Length            =>    undef, # See it *should* be here, 
                                  # but it also states it's unofficial


'Content-Disposition'       =>    undef, 
'MIME-Version'              =>    undef, 

 Subject               	    =>   '(no subject)',  
 
 Body                 	    =>   'blank', 

) unless keys %EMAIL_HEADERS; 

@EMAIL_HEADERS_ORDER = qw(
Date
From
To
Cc
Bcc
Return-Path
Reply-To
In-Reply-To
Errors-To
References
X-Priority

List
List-Archive
List-Digest
List-Help
List-ID
List-Owner
List-Post
List-Subscribe
List-Unsubscribe
List-URL
X-BeenThere

X-Habeas-SWE-1
X-Habeas-SWE-2
X-Habeas-SWE-3
X-Habeas-SWE-4
X-Habeas-SWE-5
X-Habeas-SWE-6
X-Habeas-SWE-7
X-Habeas-SWE-8
X-Habeas-SWE-9

Message-ID
Precedence

X-Mailer
X-BounceHandler

Sender
Content-type
Content-Transfer-Encoding
Content-Disposition
Content-Base

MIME-Version 

Subject
) unless scalar @EMAIL_HEADERS_ORDER; 



######################################################################



# http://mojo.skazat.com/purchase/pro.html
#
#
#
#

$GIVE_PROPS_IN_EMAIL = 0;

$GIVE_PROPS_IN_HTML = 0; 

$GIVE_PROPS_IN_ADMIN = 0;

$GIVE_PROPS_IN_SUBSCRIBE_FORM = 0;


##########################################

sub _config_import { 
	my $CONFIG_FILE_DIR;
	
	if(defined($OS) !~ m/^Win|^MSWin/i){ 
		my $getpwuid_call; 
		my $good_getpwuid;
		eval { $getpwuid_call = ( getpwuid $> )[7] };
		       $good_getpwuid = $getpwuid_call if !$@;
		
		$CONFIG_FILE_DIR = $PROGRAM_CONFIG_FILE_DIR || $ENV{'HOME'} || $good_getpwuid || '';
	}else{ 
		$CONFIG_FILE_DIR = $PROGRAM_CONFIG_FILE_DIR || $ENV{'HOME'} || '';		
	}
	my $CONFIG_FILE = $CONFIG_FILE_DIR.'/.dada_config';
	
	# yes, shooting yourself in the foot, RTM
	$CONFIG_FILE =~ /(.*)/; 
	$CONFIG_FILE = $1;
	
	if(-e $CONFIG_FILE && -f $CONFIG_FILE && -s $CONFIG_FILE){ 
		open(CONFIG, "< $CONFIG_FILE") or warn "could not open outside config file, '$CONFIG_FILE' !"; 
			my $conf;
			   $conf = do{ local $/; <CONFIG> }; 

		# shooting again, 
		$conf =~ m/(.*)/ms;
		$conf = $1;	
		eval  $conf;
		die "$PROGRAM_NAME $VER ERROR - Outside config file '$CONFIG_FILE' contains errors:\n\n $@ \n\n" if ($@);
	
	}
}


=pod

=head1 SUPPORT

If you need further support for this script, please do not email 
me directly, but use one of the following channels: 

=over

=item * Dada Mail Support Site

http://mojo.skazat.com

=item * The Dada Mailers Discussion List

http://mojo.skazat.com/cgi-bin/dada/mail.cgi/dadadev/

=item * Consultation for Dada Mail

http://mojo.skazat.com/support/customize.html

=back


=head1 CONTACT

My name is Justin Simoni

=head1 COPYRIGHT 

Copyright (c) 1999-2007 Justin Simoni All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, 
Boston, MA  02111-1307, USA.


=head1 Last Words

To riding bicycles.

=cut





# Don't remove the '1'. It lives here at the bottom. It likes it there.

1;


